package com.liquidnet.service.order.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import com.liquidnet.service.goblin.dto.vo.GoblinNftOrderVo;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayCallbackParam;
import com.liquidnet.service.order.utils.GoblinNftOrderUtils;
import com.liquidnet.service.order.utils.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Service
@Slf4j
public class OrderApplePayServiceImpl {

    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinNftOrderUtils nftOrderUtils;

    @Autowired
    private GoblinNftOrderServiceImpl goblinNftOrderService;
    @Autowired
    private IDragonOrdersService dragonOrdersService;

    /*@Value("${liquidnet.service.order.url-pay.applePay}")
    private String payUrl;*/

    public boolean pay(String orderId, String type, String receiptData, String transactionId) {
        try {
            log.info("苹果支付成功通知参数 [orderId:{},type:{},receiptData:{},transactionId:{}]", orderId, type, receiptData, transactionId);
            GoblinNftOrderVo nftOrder = nftOrderUtils.getNftOrder(orderId);
            if (null == nftOrder) {
                log.info("未找到该订单 [orderId:{}]", orderId);
                return false;
            }
            /*LinkedMultiValueMap<String, String> httpData = CollectionUtil.linkedMultiValueMapStringString();
            httpData.add("type", type);
            httpData.add("price", nftOrder.getPriceActual().toString());
            httpData.add("name", nftOrder.getStoreName());
            GoblinGoodsSkuInfoVo skuVo = goblinRedisUtils.getGoodsSkuInfoVo(nftOrder.getSkuId());
            httpData.add("detail", skuVo.getName());
            httpData.add("orderCode", nftOrder.getOrderCode());
            httpData.add("orderId", nftOrder.getOrderId());
            httpData.add("clientIp", CurrentUtil.getCliIpAddr());
            httpData.add("notifyUrl", "");
            httpData.add("createDate", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            httpData.add("expireTime", "5");
            httpData.add("payType", nftOrder.getPayType());
            httpData.add("deviceFrom", nftOrder.getDeviceFrom());
            httpData.add("openId", "");
            httpData.add("showUrl", "");
            httpData.add("returnUrl", "");
            httpData.add("receiptData", receiptData);
            httpData.add("transactionId", transactionId);

            LinkedMultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            String returnData = HttpUtil.post(payUrl, httpData, header);
            log.info("苹果支付调用DRAGON结果 = " + returnData);
            ResponseDto<GoblinApplePayInnerResultVo> dto = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<GoblinApplePayInnerResultVo>>() {
            });
            GoblinApplePayInnerResultVo dtoData = dto.getData();*/

            DragonPayBaseReqDto dragonPayBaseReqDto = DragonPayBaseReqDto.getNew();
            dragonPayBaseReqDto.setPayType(nftOrder.getPayType());
            dragonPayBaseReqDto.setDeviceFrom(nftOrder.getDeviceFrom());
            dragonPayBaseReqDto.setType(type);
            dragonPayBaseReqDto.setPrice(nftOrder.getPriceActual());
            dragonPayBaseReqDto.setName(nftOrder.getStoreName());
            dragonPayBaseReqDto.setDetail("");
            dragonPayBaseReqDto.setOrderCode(nftOrder.getOrderCode());
            dragonPayBaseReqDto.setOrderId(orderId);
            dragonPayBaseReqDto.setClientIp(CurrentUtil.getCliIpAddr());
            dragonPayBaseReqDto.setNotifyUrl("");
            dragonPayBaseReqDto.setReturnUrl("");
            dragonPayBaseReqDto.setShowUrl("");
            dragonPayBaseReqDto.setCreateDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            dragonPayBaseReqDto.setExpireTime("5");
            dragonPayBaseReqDto.setReceiptData(receiptData);
            dragonPayBaseReqDto.setTransactionId(transactionId);
            //调用苹果
            DragonPayBaseRespDto dragonPayBaseRespDto = dragonOrdersService.dragonNotifyApple(dragonPayBaseReqDto);

            if (null == dragonPayBaseRespDto || dragonPayBaseRespDto.getStatus() != 0) {
                return false;
            } else {
                // 支付成功
                GoblinNftOrderPayCallbackParam NftOrderPayCallbackParam = GoblinNftOrderPayCallbackParam.getNew();
                NftOrderPayCallbackParam.setCode(dragonPayBaseRespDto.getCode());
                NftOrderPayCallbackParam.setOrderCode(nftOrder.getOrderCode());
                NftOrderPayCallbackParam.setPaymentAt(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmss));
                NftOrderPayCallbackParam.setPrice(nftOrder.getPriceActual());
                NftOrderPayCallbackParam.setPaymentId(transactionId);
                NftOrderPayCallbackParam.setPaymentType(nftOrder.getDeviceFrom().concat(nftOrder.getPayType()).toUpperCase());
                NftOrderPayCallbackParam.setStatus(1);
                if (type.equals("NFT")) {
                    String isSync = goblinNftOrderService.syncOrder(NftOrderPayCallbackParam);
                    if (!isSync.equals("success")) {
                        return false;
                    }
                }
                return true;
            }
        } catch (Exception e) {
            log.error("OrderApplePayServiceImplE e:{}", e);
            return false;
        }
    }
}
