package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.GoblinNftNumAccountServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "NFT数字账户-adam使用")
@RestController
@Validated
@RequestMapping("/nftNumAccount")
public class GoblinNftNumAccountController {

    @Autowired
    GoblinNftNumAccountServiceImpl accountService;

    @PostMapping("sync")
    @ApiOperation("数字账户开通同步通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "userId", value = "用户ID", example = "1", required = true),
    })
    public ResponseDto<Boolean> syncNotice(
            @RequestParam("userId") String userId
    ) {
        Boolean notice = accountService.syncNotice(userId);
        if (notice) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }

}
