package com.liquidnet.service.order.utils;

import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinIpAreaVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.HashMap;

@Component
public class QueueUtils {

    //    @Autowired
//    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    DataUtils dataUtils;

    /**
     * 发送 SqlMapping Json 字符串
     *
     * @param exchange 交换机
     * @param route    路径
     * @param sqlStr   Json字符串
     */
//    public void sendSqlRabbit(String exchange, String route, String sqlStr) {
//            rabbitTemplate.convertAndSend(exchange, route, sqlStr);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = ObjectUtil.cloneHashMapStringAndString();
        map.put(MQConst.QUEUE_MESSAGE_KEY, jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }


    /**
     * 发送消息 - REDIS Goblin回滚待支付订单库存
     *
     * @param createTime      订单创建时间
     * @param masterOrderCode Goblin主订单号
     */
    public void sendMsgByRedisGoblinStock(String masterOrderCode, LocalDateTime createTime, String type) {
        String streamKey;
        int key = createTime.getMinute() % 10;
        switch (key) {
            case 1:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_1.getKey();
                break;
            case 2:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_2.getKey();
                break;
            case 3:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_3.getKey();
                break;
            case 4:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_4.getKey();
                break;
            case 5:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_5.getKey();
                break;
            case 6:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_6.getKey();
                break;
            case 7:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_7.getKey();
                break;
            case 8:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_8.getKey();
                break;
            case 9:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_9.getKey();
                break;
            default:
                streamKey = MQConst.GoblinQueue.GOBLIN_UN_PAY_0.getKey();
                break;
        }
        HashMap<String, String> map = ObjectUtil.cloneHashMapStringAndString();
        map.put("id", masterOrderCode);
        map.put("type", type);
        map.put("time", createTime.toString());
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }

    public void pushPvUv(String uid, String accessType, String performanceId, String orderId, String orderCode, String ipAddress) {
        try {
            KylinIpAreaVo vo = dataUtils.getKylinIpAreaVo(ipAddress);
            String area = vo.getArea();
            String areaProvince = vo.getProvince();
            String areaCity = vo.getCity();
            String areaCounty = vo.getCounty();
            sendMsgByRedis(MQConst.KylinQueue.SQL_PERFORMANCE_LACK.getKey(),
                    SqlMapping.get("bi_ticket_access_records.insert", new Object[]{
                            uid, accessType, performanceId, orderId, orderCode,
                            ipAddress, area, areaProvince, areaCity, areaCounty,
                            LocalDateTime.now(),
                    }));
        } catch (Exception e) {

        }
    }
}
