package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.vo.WalletTransactionInfoVo;
import io.swagger.annotations.ApiModel;

import java.util.List;

/**
 * WalletTransactionQueryResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/5
 */
@ApiModel(value = "WalletTransactionQueryResult", description = "Result of wallet transaction query")
public class WalletTransactionQueryResult extends WalletCallResult<WalletTransactionQueryParam> {
    private static final long serialVersionUID = 4632424467638252670L;
    private List<WalletTransactionInfoVo> transDetailList;

    public WalletTransactionQueryResult() {
    }

    public WalletTransactionQueryResult(List<WalletTransactionInfoVo> transDetailList) {
        this.transDetailList = transDetailList;
    }

    public WalletTransactionQueryResult(String code, String message) {
        super(code, message);
    }

    public List<WalletTransactionInfoVo> getTransDetailList() {
        return transDetailList;
    }
}
