package com.liquidnet.service.reconciliation.strategy.parser;

import com.liquidnet.service.reconciliation.strategy.transtype.ITransTypeStrategy;
import com.liquidnet.service.reconciliation.strategy.transtype.annotation.StrategyTransTypeHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 服务启动初始化策略容器-数据解析
 * @class: TransTypeStrategyListener
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:38
 */
@Component
public class DataParserStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyTransTypeHandler.class);
        DataParserStrategyContext strategyContext = event.getApplicationContext().getBean(DataParserStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyTransTypeHandler typeHandler = bean.getClass().getAnnotation(StrategyTransTypeHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (ITransTypeStrategy) bean);
        });
    }
}