package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 订单快递运费
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderExpressFeeInfo implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String orderExpressFeeInfoId;
    private String orderExpressId;
    private String type;
    private String name;
    private BigDecimal value;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;

    private static final KylinOrderExpressFeeInfo obj = new KylinOrderExpressFeeInfo();
    public static KylinOrderExpressFeeInfo getNew() {
        try {
            return (KylinOrderExpressFeeInfo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderExpressFeeInfo();
        }
    }
}
