package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerKylinSqlOrderWithdrawRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_ORDER_WITHDRAW;

@Configuration
public class ConsumerKylinSqlOrderWithdrawRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSqlOrderWithdrawRdsReceiver consumerKylinSqlOrderWithdrawRdsReceiver;

    /**
     * 订单申请撤回
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlOrderWithdraw(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(SQL_ORDER_WITHDRAW.getGroup(), getConsumerName(SQL_ORDER_WITHDRAW.name() + t)),
                StreamOffset.create(SQL_ORDER_WITHDRAW.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlOrderWithdrawRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 订单申请撤回 */

    @Bean
    public Subscription subscriptionSqlOrderWithdraw0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOrderWithdraw(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

//    @Bean
//    public Subscription subscriptionSqlOrderWithdraw1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlOrderWithdraw(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlOrderWithdraw2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlOrderWithdraw(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

//    @Bean
//    public Subscription subscriptionSqlOrderWithdraw3(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlOrderWithdraw(listenerContainer, 3);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlOrderWithdraw4(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlOrderWithdraw(listenerContainer, 4);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
