package com.liquidnet.service.stone.util;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.constant.MQConst;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class QueueUtils {

//    @Autowired
//    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 发送消息 - RABBIT
     *
     * @param exchange 交换机
     * @param routeKey 路径
     * @param jsonMsg  Json字符串
     */
//    public void sendSqlRabbit(String exchange, String routeKey, String jsonMsg) {
//        rabbitTemplate.convertAndSend(exchange, routeKey, jsonMsg);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put(MQConst.QUEUE_MESSAGE_KEY, jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }
}
