package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分活动奖品里关联多奖品表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivityPrizeRelation implements Serializable, Cloneable {

    private static final long serialVersionUID = 3400664786004300429L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * prize_relation_id
     */
    private String prizeRelationId;

    /**
     * prize_id
     */
    private String prizeId;

    /**
     * 券id
     */
    private String couponId;

    /**
     * 券名称
     */
    private String couponTitle;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivityPrizeRelation obj = new SweetIntegralActivityPrizeRelation();

    public static SweetIntegralActivityPrizeRelation getNew() {
        try {
            return (SweetIntegralActivityPrizeRelation) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeRelation();
        }
    }


}
