package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 券发放管理
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyMgtCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String mcouponId;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 发放状态[0-未发放|1-已发放|2-无效｜3-已取消｜9-发放中|10-会员礼包初始模版]
     */
    private Integer state;

    /**
     * 发放量
     */
    private Integer eventAmt;

    /**
     * 发放类型[10-全体用户｜1-会员｜2-手机号]
     */
    private Integer eventType;

    /**
     * `发放类型`为2-手机号时发放手机号以,分隔
     */
    private String eventLimit;

    /**
     * 发放时间(立即-当前时间+3分钟｜预约-点选时间)
     */
    private LocalDateTime eventAt;

    /**
     * 任务驱动[0-系统自动,1-人为创建]
     */
    private Integer eventDriven;

    /**
     * 专享标识[0-常规｜1-会员专属]
     * <p>
     * 变更前：`candy_coupon.exclusive`用于根据会员有效期设置券有效期及标识用户端券分类（普通券、会员券等）；
     * 变更后：
     * 原`candy_coupon.exclusive`废除
     * 实际发放逻辑中，原标识"是否根据会员有效期设置券有效期"的`candy_coupon.exclusive`字段改为`candy_mgt_coupon.exclusively`
     * 在`candy_user_coupon`及`candy_common_coupon`中添加`exclusive`字段，发放时直接由`candy_mgt_coupon.exclusively`赋值该属性
     * </p>
     */
    private Integer exclusively;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
