package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.mapper.AdamAddressesMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SyncAddressesProcessor extends SyncDataProcessorService {
    @Autowired
    AdamAddressesMapper addressesMapper;

    @Override
    public void dataProcessing(int stp) {
        LambdaQueryWrapper<AdamAddresses> lambdaQueryWrapper =
                Wrappers.lambdaQuery(AdamAddresses.class).eq(AdamAddresses::getState, 1)
                .orderByDesc(AdamAddresses::getMid);
        Integer totalCount = addressesMapper.selectCount(lambdaQueryWrapper);
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{}/{}, {} ~ {}", totalCount, offset, nth, pct);



        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - {} begin", rows, offset, nth);


            PageHelper.startPage(nth + 1, offset);
            List<AdamAddresses> dtos = addressesMapper.selectList(lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamAddresses dto = dtos.get(i);

                    AdamUserInfoVo userInfoVo = dmRdmService.getUserInfoVoByUid(dto.getUid());
                    if (null != userInfoVo) {
                        AdamAddressesVo vo = AdamAddressesVo.getNew().copy(dto);
                        //log.info("vo:{}", JsonUtils.toJson(vo));

                        dmRdmService.addAddressesVoByUid(dto.getUid(), dmRdmService.getAddressesVoByUid(dto.getUid()), vo);

                        pct++;
                    }
                }
            }



            log.info("Sync.processing.limit {},{} - {} handle.counts:{}", rows, offset, nth, pct);
            nth++;
            totalRows -= offset;
        }



        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
