package com.liquidnet.service.kylin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagCodeDetailVo;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagScopeVo;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagVo;

import java.util.List;

public interface IKylinLuckyBagService {
    /**
     * 根据订单ID获取福袋
     * @param orderId
     * @return
     */
    KylinLuckyBagVo getLuckyBagByOrderId(String orderId);

    /**
     * 获取福袋验码列表
     * @param mobile
     * @return
     */
    List<KylinLuckyBagScopeVo> getLuckyBagListScope(String mobile);

    /**
     * 获取福袋详情
     *
     * @param authMobile
     * @param code
     * @param luckyBagId
     * @return
     */
    ResponseDto<KylinLuckyBagCodeDetailVo> getCodeDetail(String authMobile, String code, String luckyBagId);

    /**
     * 验码
     * @param authMobile
     * @param code
     * @param luckyBagId
     * @return
     */
    ResponseDto<Boolean> consumeCode(String authMobile, String code, String luckyBagId);
}
