package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyTradeServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 14:19
 */
@Slf4j
@Service("galaxyTradeServiceImpl")
public class GalaxyTradeServiceImpl implements IGalaxyTradeService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuy(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftPublishAndBuy(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuyResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(GalaxyNftBuyPayResultQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuyPayResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftPublishAndBuyResultQuery(reqDto);
    }
}
