package com.liquidnet.client.admin.zhengzai.adam.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExpressExportListDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderExpressExportExcelListDao implements Serializable, Cloneable {

    private static final long serialVersionUID = -2867045876880344637L;

    @Excel(name = "票种")
    private String title;
    @Excel(name = "使用时间")
    private String useStart;
    @Excel(name = "订单编号")
    private String orderCode;
    @Excel(name = "购买数量")
    private Integer number;
    @Excel(name = "用户名称")
    private String userName;
    @Excel(name = "用户手机号")
    private String userMobile;
    @Excel(name = "收货人姓名")
    private String expressContacts;
    @Excel(name = "收货人手机号")
    private String expressPhone;
    @Excel(name = "收货地址")
    private String expressAddress;
    @Excel(name = "入场人姓名")
    private String enterName;
    @Excel(name = "入场人手机号")
    private String enterMobile;
    @Excel(name = "入场人身份证")
    private String enterIdCod;

    private static final OrderExpressExportExcelListDao obj = new OrderExpressExportExcelListDao();

    public static OrderExpressExportExcelListDao getNew() {
        try {
            return (OrderExpressExportExcelListDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new OrderExpressExportExcelListDao();
        }
    }

    public OrderExpressExportExcelListDao copy(OrderExpressExportListDao source) {
        if (null == source) return this;
        this.setTitle(source.getTitle());
        this.setUseStart(source.getUseStart());
        this.setOrderCode(source.getOrderCode());
        this.setNumber(source.getNumber());
        this.setUserName(source.getUserName());
        this.setUserMobile(source.getUserMobile());
        this.setExpressContacts(source.getExpressContacts());
        this.setExpressPhone(source.getExpressPhone());
        this.setExpressAddress(source.getExpressAddress());
        this.setEnterName(source.getEnterName());
        this.setEnterMobile(source.getEnterMobile());
        this.setEnterIdCod(source.getEnterIdCod());
        return this;
    }
}
