package com.liquidnet.service.bank.currencycloud.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.currencycloud.client.model.Transactions;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcTransactionQuery;
import com.liquidnet.service.bank.currencycloud.service.IBankCcTransactionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-22
 */
@Api(tags = "transaction")
@Slf4j
@RestController
@RequestMapping("/bank-cc-transaction")
public class BankCcTransactionController {

    @Autowired
    IBankCcTransactionService bankCcTransactionService;

    @ApiOperation(value = "find transactions")
    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @PostMapping("/find")
    public ResponseDto<Transactions> findTransactions(HttpServletRequest request,
                                                      @RequestBody BankCcTransactionQuery param) {
        String logFx = "find transactions.";
        log.info(logFx + "BankCcTransactionQuery=[{}]", JSON.toJSONString(param, SerializerFeature.WriteMapNullValue));
        ResponseDto<Transactions> transactions;
        try {

            transactions = bankCcTransactionService.findTransactions(param);
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return transactions;
    }

}
