package com.liquidnet.service.adam.controller;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileRequest;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileResponse;
import com.aliyuncs.exceptions.ClientException;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.core.JwtValidator;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamLoginInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.adam.service.IAdamThirdPartyService;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.DigestUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiSupport(order = 10010)
@Api(tags = "用户登录")
@Slf4j
@RestController
@RequestMapping("")
public class AdamLoginController {
    @Autowired
    Environment environment;
    @Autowired
    JwtValidator jwtValidator;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    DefaultAcsClient defaultAcsClient;
    @Autowired
    IAdamUserService adamUserService;
    @Autowired
    IAdamRealNameService adamRealNameService;
    @Autowired
    IAdamThirdPartyService adamThirdPartyService;

    /*@ApiOperationSupport(order = 1)
    @ApiOperation(value = "手机号密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "password", value = "密码"),
    })
    @PostMapping(value = {""})
    public ResponseDto<AdamLoginInfoVo> loginByPwd(@RequestParam String mobile, @RequestParam String password) {
        log.info("mobile:{},pwd:{}", mobile, password);
        DigestUtils.md5DigestAsHex((password + "salt_").getBytes(StandardCharsets.UTF_8));


        return ResponseDto.success(AdamLoginInfoVo.getNew());
    }*/

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "发送验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
    })
    @GetMapping(value = {"send"})
    public ResponseDto<Object> sendSms(@RequestParam String mobile) {
        log.info("send to mobile:{}", mobile);

        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.add("mobile", mobile);
        LinkedMultiValueMap<String, String> headersMap = new LinkedMultiValueMap<>();
        headersMap.add("token", null);

        try {
            // TODO: 2021/5/12
            String respStr = HttpUtil.post("https://service.zhengzai.tv/smsCode", paramsMap, headersMap);
            log.info("###PHP.API[{}].RESP[{}]", "https://service.zhengzai.tv/smsCode", respStr);

//            Map respMap = JsonUtils.fromJson(respStr, Map.class);

        } catch (Exception e) {
            log.error("验证码发送异常[mobile:{}]", mobile, e);
            return ResponseDto.failure(ErrorMapping.get("10001"));
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "手机号验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"login/sms"})
    public ResponseDto<AdamLoginInfoVo> loginBySms(@RequestParam String mobile, @RequestParam String code) {
        // TODO: 2021/5/12 参数检验
        log.info("mobile:{},pwd:{}", mobile, code);

        if (!this.checkSmsCode(mobile, code)) return ResponseDto.failure("验证码无效");

        String uid = adamUserService.queryUidByRedis(mobile);
        AdamUserInfoVo userInfoVo =
                StringUtils.isEmpty(uid) ? adamUserService.register(mobile) : adamUserService.queryByUid(uid);
        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (userInfoVo.getIsComplete() == 1) {
            loginInfoVo.setRealNameInfo(adamRealNameService.queryByUid(userInfoVo.getUid()));
            loginInfoVo.setThirdPartInfo(adamThirdPartyService.queryByUid(userInfoVo.getUid()));
            // TODO: 2021/5/12 会员信息
            loginInfoVo.setMemberInfo(null);
        }
        loginInfoVo.setUserInfo(userInfoVo);

        Map<String, Object> claimsMap = new HashMap<>();
        claimsMap.put("uid", userInfoVo.getUid());
        loginInfoVo.setToken(this.ssoProcess(claimsMap));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "手机号一键登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "accessToken", value = "访问令牌"),
    })
    @PostMapping(value = {"login/mobile"})
    public ResponseDto<AdamLoginInfoVo> loginByMobile(@RequestParam String accessToken) {
        // TODO: 2021/5/10
        log.info("login by mobile access token:{}", accessToken);

        String mobile = this.getMobile(accessToken);
        if (StringUtils.isEmpty(mobile)) return ResponseDto.failure("手机号获取失败，请更换登录方式");

        String uid = adamUserService.queryUidByRedis(mobile);
        AdamUserInfoVo userInfoVo =
                StringUtils.isEmpty(uid) ? adamUserService.register(mobile) : adamUserService.queryByUid(uid);
        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (loginInfoVo.getUserInfo().getIsComplete() == 1) {
            loginInfoVo.setRealNameInfo(adamRealNameService.queryByUid(userInfoVo.getUid()));
            loginInfoVo.setThirdPartInfo(adamThirdPartyService.queryByUid(userInfoVo.getUid()));
            // TODO: 2021/5/12 会员信息
            loginInfoVo.setMemberInfo(null);
        }
        loginInfoVo.setUserInfo(userInfoVo);

        Map<String, Object> claimsMap = new HashMap<>();
        claimsMap.put("uid", userInfoVo.getUid());
        loginInfoVo.setToken(this.ssoProcess(claimsMap));
        return ResponseDto.success(AdamLoginInfoVo.getNew());
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "第三方账号登录")
    @PostMapping(value = {"login/tpa"})
    public ResponseDto<AdamLoginInfoVo> loginByTpa(@RequestBody AdamThirdPartParam parameter) {
        // TODO: 2021/5/10
        log.info("login by tpa:{}", JsonUtils.toJson(parameter));

        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (StringUtils.isEmpty(parameter.getMobile())) {
            String uid = adamUserService.queryUidByRedis(parameter.getOpenId(), parameter.getPlatform());
            if (StringUtils.isEmpty(uid)) return ResponseDto.failure("第三方账号未注册");

            loginInfoVo.setUserInfo(adamUserService.queryByUid(uid));
            loginInfoVo.setRealNameInfo(adamRealNameService.queryByUid(uid));
            loginInfoVo.setThirdPartInfo(adamThirdPartyService.queryByUid(uid));
        } else {// 新账号注册
            if (!this.checkSmsCode(parameter.getMobile(), parameter.getCode())) return ResponseDto.failure("验证码无效");

            loginInfoVo.setUserInfo(adamUserService.register(parameter));
            loginInfoVo.setThirdPartInfo(adamThirdPartyService.queryByUid(loginInfoVo.getUserInfo().getUid()));
        }

        Map<String, Object> claimsMap = new HashMap<>();
        claimsMap.put("uid", loginInfoVo.getUserInfo().getUid());
        loginInfoVo.setToken(this.ssoProcess(claimsMap));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "登出")
    @PostMapping(value = {"logout"})
    public ResponseDto<Object> logout(HttpServletRequest request) {
        String authorization = request.getHeader("authorization");

        String ssoKey = jwtValidator.getSsoRedisKey().concat(
                DigestUtils.md5DigestAsHex(authorization.substring(7).getBytes(StandardCharsets.UTF_8))
        );

        redisUtil.set(ssoKey, false);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "注销")
    @PostMapping(value = {"close"})
    public ResponseDto<Object> close(HttpServletRequest request) {
        adamUserService.close(CurrentUtil.getCurrentUid());
        return this.logout(request);
    }

    /* ---------------------------- Internal Method ---------------------------- */

    private boolean checkSmsCode(String mobile, String code) {
        if ("dev".equals(environment.getProperty("spring.profiles.active")) && "111111".equals(code)) {
            return true;
        }

        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.add("mobile", mobile);
        paramsMap.add("code", code);
        LinkedMultiValueMap<String, String> headersMap = new LinkedMultiValueMap<>();
        headersMap.add("token", null);

        try {
            // TODO: 2021/5/12
            String respStr = HttpUtil.get("https://service.zhengzai.tv/smsValidation", paramsMap, headersMap);
            log.info("###PHP.API.RESP:{}", respStr);

            Map respMap = JsonUtils.fromJson(respStr, Map.class);

            return StringUtils.equalsIgnoreCase("OK", (String) respMap.get("message"));
        } catch (Exception e) {
            log.error("验证码验证异常[mobile:{},code:{}]", mobile, code, e);
            return false;
        }
    }

    private String getMobile(String accessToken) {
        try {
            GetMobileRequest request = new GetMobileRequest();
            request.setAccessToken(accessToken);

            GetMobileResponse response = defaultAcsClient.getAcsResponse(request);

            if (!Objects.isNull(response) && response.getCode().equalsIgnoreCase("OK")) {
                return response.getGetMobileResultDTO().getMobile();
            }
        } catch (ClientException e) {
            log.error("error:aliyun.dypns.api:{}", accessToken, e);
        }
        return null;
    }

    private String ssoProcess(Map<String, Object> claimsMap) {
        redisUtil.delKeysByPrefix(jwtValidator.getSsoRedisKey());

        String token = jwtValidator.create(claimsMap);

        String ssoKey = jwtValidator.getSsoRedisKey().concat(DigestUtils.md5DigestAsHex(token.getBytes(StandardCharsets.UTF_8)));

        redisUtil.set(ssoKey, true, jwtValidator.getExpireTtl() * 60);

        return token;
    }
}
