package com.liquidnet.service.slime.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.KylinExpressModuleVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketExpressModuleVo;
import com.liquidnet.service.slime.constant.SlimeRedisConst;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsVo;
import com.liquidnet.service.slime.service.SlimeRdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class RedisSlimeUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoSlimeUtils mongoSlimeUtils;
    @Autowired
    private InnerUtils innerUtils;
    @Autowired
    SlimeRdmService rdmService;
    @Autowired
    PerformanceUtils performanceUtils;


    // 获取购票须知
    public List<KylinBuyNoticeVo> getBuyNotice() {
        Object obj = redisUtil.get(KylinRedisConst.BUY_NOTICE);
        if (obj != null) {
            return (List<KylinBuyNoticeVo>) obj;
        } else {
            return innerUtils.getBuyNotice();
        }
    }

    //判断key是否存在
    public boolean hasKey(String key) {
        return redisUtil.hasKey(key);
    }

    //获取场地redis
    public SlimeFieldsVo getFieldVo(String fieldId) {
        return rdmService.getFieldsVoByFieldId(fieldId);
    }

    /**
     * 根据演出id 获取 演出vo 详情
     *
     * @param performanceId
     * @return
     */
    public KylinPerformanceVo getPerformanceVo(String performanceId) {
        Object obj = redisUtil.get(KylinRedisConst.PERFORMANCES + performanceId);
        if (obj != null) {
            return (KylinPerformanceVo) obj;
        } else {
            KylinPerformanceVo performanceData = mongoSlimeUtils.getPerformanceVo(performanceId);
            redisUtil.set(KylinRedisConst.PERFORMANCES + performanceId, performanceData);
            return performanceData;
        }
    }

    /**
     * 根据演出id 删除 演出vo 详情
     *
     * @param performanceId
     * @return
     */
    public void delPerformanceVo(String performanceId) {
        redisUtil.del(KylinRedisConst.PERFORMANCES + performanceId);
    }

    public KylinPerformanceVo getPerformanceVoNoMerchant(String performanceId) {
        Object obj = redisUtil.get(KylinRedisConst.PERFORMANCES + performanceId);
        if (obj != null) {
            return (KylinPerformanceVo) obj;
        } else {
            KylinPerformanceVo performanceData = mongoSlimeUtils.getPerformanceVoNoMerchant(performanceId);
            redisUtil.set(KylinRedisConst.PERFORMANCES + performanceId, performanceData);
            return performanceData;
        }
    }


    /**
     * 初始化普通库存
     *
     * @param ticketId     票id
     * @param totalGeneral 普通库存
     */
    public void setSurplusGeneral(String ticketId, int totalGeneral) {
        redisUtil.set(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_GENERAL, totalGeneral);
    }


    /**
     * 设置 票种快递票模板关联vo [第三方非线上]
     *
     * @param ticketId 票id
     */
    public void setTEMMerchantVo(String ticketId, KylinTicketExpressModuleVo vo) {
        redisUtil.set(KylinRedisConst.TICKET_EXPRESS_MODULE_P.concat(ticketId), vo);
    }

    /**
     * 获取 票种快递票模板关联vo [第三方非线上]
     *
     * @param ticketId
     * @return
     */
    public KylinTicketExpressModuleVo getTEMMerchantVo(String ticketId) {
        String redisKey = KylinRedisConst.TICKET_EXPRESS_MODULE_P.concat(ticketId);
        Object obj = redisUtil.get(redisKey);
        if (obj != null) {
            return (KylinTicketExpressModuleVo) obj;
        } else {
            return null;
        }
    }

    /**
     * 设置 票种快递票模板关联vo [线上]
     *
     * @param ticketId 票id
     */
    public void setTEMVo(String ticketId, KylinTicketExpressModuleVo vo) {
        redisUtil.set(KylinRedisConst.TICKET_EXPRESS_MODULE.concat(ticketId), vo);
    }

    /**
     * 获取 票种快递票模板关联vo [线上]
     *
     * @param ticketId
     * @return
     */
    public KylinTicketExpressModuleVo getTEMVo(String ticketId) {
        String redisKey = KylinRedisConst.TICKET_EXPRESS_MODULE.concat(ticketId);
        Object obj = redisUtil.get(redisKey);
        if (obj != null) {
            return (KylinTicketExpressModuleVo) obj;
        } else {
            return null;
        }
    }

    /**
     * 获取普通剩余库存
     *
     * @param ticketId 票id
     * @return 普通剩余库存
     */
    public int getSurplusGeneral(String ticketId) {
        return (int) redisUtil.get(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_GENERAL);
    }

    /**
     * 修改普通库存 并 返回修改后的数量
     *
     * @param ticketId       票id
     * @param surplusGeneral 普通库存
     * @return 普通剩余库存
     */
    public int changeSurplusGeneral(String ticketId, int surplusGeneral) {
        if (surplusGeneral > 0) {
            return (int) redisUtil.incr(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_GENERAL, surplusGeneral);
        } else {
            return (int) redisUtil.decr(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_GENERAL, Math.abs(surplusGeneral));
        }
    }

    /**
     * 初始化兑换库存
     *
     * @param ticketId      票id
     * @param totalExchange 兑换库存
     */
    public void setSurplusExchange(String ticketId, int totalExchange) {
        redisUtil.set(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_EXCHANGE, totalExchange);
    }

    /**
     * 变更兑换库存 并 返回 修改后的数量
     *
     * @param ticketId        票id
     * @param surplusExchange 普通库存
     * @return 兑换剩余库存
     */
    public int changeSurplusExchange(String ticketId, int surplusExchange) {
        if (surplusExchange > 0) {
            return (int) redisUtil.incr(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_EXCHANGE, surplusExchange);
        } else {
            return (int) redisUtil.decr(KylinRedisConst.PERFORMANCES_INVENTORY + ticketId + ":" + KylinRedisConst.SURPLUS_EXCHANGE, Math.abs(surplusExchange));
        }
    }

    /**
     * 演出是否实名
     *
     * @param performanceId
     * @param isTrueName
     */
    public void setPerformanceIsTrueName(String performanceId, int isTrueName) {
        redisUtil.set(KylinRedisConst.PERFORMANCES_TRUE_NAME + performanceId, isTrueName);
    }


    public void updatePerformanceMongo(String performanceIds, KylinPerformanceVo paramVo) {
        //查询 mysql 数据
        KylinPerformanceVo vo;
        if (null == paramVo) {
            vo = performanceUtils.combinePerformanceVoData(performanceIds);
        } else {
            vo = paramVo;
        }
        if (vo != null) {
            try {
                //删除 mongo数据
                mongoSlimeUtils.delPerformanceVo(performanceIds);
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                //新增 mongo数据
                mongoSlimeUtils.insertPerformanceVo(vo);
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                //删除redis
                redisUtil.del(KylinRedisConst.PERFORMANCES + performanceIds);
                // 大龙相关 演出列表
                redisUtil.del(KylinRedisConst.PERFORMANCES_LIST_CITYNAME + vo.getCityName());
                redisUtil.del(KylinRedisConst.PERFORMANCES_ROADLIST + vo.getRoadShowId());
                redisUtil.del(KylinRedisConst.PERFORMANCES_LIST_SYSTEM_RECOMMEND);
                redisUtil.del(KylinRedisConst.PERFORMANCES_LIST_RECOMMEND);
                redisUtil.del(KylinRedisConst.PERFORMANCES_LIST_NOTICE);
                redisUtil.del(KylinRedisConst.PERFORMANCES_LIST_EXCLUSIVE);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
        }
    }

    /**
     * 可选快递方式列表
     *
     * @return
     */
    public List<KylinExpressModuleVo> expressList() {
        String redisKey = KylinRedisConst.KYLIN_EXPRESS_MODULES;
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return (List<KylinExpressModuleVo>) obj;
        }
    }

    /**
     * 是否为超级权限账户
     *
     * @return
     */
    public Boolean superAccount(String merchantId) {
        String redisKey = SlimeRedisConst.SUPER_ACCOUNT.concat(merchantId);
        return redisUtil.hasKey(redisKey);
    }
}
