package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.kylin.entity.KylinBanners;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 轮播图 添加、修改banner需要的参数
 * </p>
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
public class BannersParam implements Serializable {
    @ApiModelProperty(value = "Banner主键ID", example = "9822346783245")
    private String bannersId;

    @ApiModelProperty(value = "标题", required = true, example = "这是一个banner标题")
    @NotBlank(message = "请填写标题")
    private String bannersName;

    @ApiModelProperty(value = "封面图", required = true, example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "请上传封面图")
    private String coverImg;

    @ApiModelProperty(value = "跳转类型 具体类型有接口提供", required = true, example = "6")
    @Min(value = 1, message = "请选择跳转类型")
    private Integer targetType;

    @ApiModelProperty(value = "跳转目标id或者url 不跳转则为空", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    private String targetObj;

    @ApiModelProperty(value = "是否上线展示 0下线 1上线", required = true, example = "1", allowableValues = "0,1")
    @Min(value = 1, message = "请选择是否上线")
    private Integer isOnline;

    @ApiModelProperty(value = "上线开始时间", example = "2021-05-01 11:22:33")
    private String onlineStartTime;

    @ApiModelProperty(value = "上线结束时间", example = "2021-05-01 11:22:33")
    private String onlineEndTime;

    @ApiModelProperty(value = "推广类型 1全国 2省份", required = true, example = "1", allowableValues = "1,2")
    @Min(value = 1, message = "请选择推广类型")
    private Integer promotionType;

    @ApiModelProperty(value = "排序权重 越大越靠前", example = "100")
    private Integer BannersSort;

    @ApiModelProperty(value = "备注", example = "这是一个演出推广的banner")
    private String remarks;

    @ApiModelProperty(value = "展示的位置 多选 数组", example = "[\"1\", \"4\", \"3\", \"5\", \"6\", \"8\"]")
    @NotEmpty(message = "请选择展示位置")
    private List positionList;

    @ApiModelProperty(value = "推广省份 多选 数组", example = "[\"1\", \"2\", \"5\"]")
//    @NotEmpty(message = "请选择推广省份")
    private List provincesList;

    @JsonIgnore
    public KylinBanners getFields(String bannersId, String createdAt) {
        KylinBanners fields = new KylinBanners();
        BeanUtils.copyProperties(this, fields);
        if (null != bannersId) {
            fields.setBannersId(bannersId);
        }
        if (null != createdAt) {
            fields.setCreatedAt(createdAt);
        }
        return fields;
    }
}
