package com.liquidnet.service.stone.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.entity.StoneScoreOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel
public class StoneOrderListVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "orderId", example = "1")
    private String orderId;

    @ApiModelProperty(value = "积分物品封面图", example = "http://xxxxx.png")
    private String img;

    @ApiModelProperty(value = "积分物品名称", example = "测试券")
    private String targetTitle;

    @ApiModelProperty(value = "购买数量", example = "1")
    private Integer number;

    @ApiModelProperty(value = "支付积分", example = "100.00")
    private Integer score;

    @ApiModelProperty(value = "支付价格", example = "0.00")
    private BigDecimal price;

    @ApiModelProperty(value = "状态状态[-999-全部|-1-删除|0-未上架|1-已上架|2-定时上架|7-已下架|8-售罄]", example = "1")
    private Integer status;

    @ApiModelProperty(value = "订单号", example = "123123")
    private String orderCode;

    @ApiModelProperty(value = "创建时间", example = "2021-12-01 12:21:32")
    private String createdAt;

    private static final StoneOrderListVo obj = new StoneOrderListVo();

    public static StoneOrderListVo getNew() {
        try {
            return (StoneOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneOrderListVo();
        }
    }

    public StoneOrderListVo copy(StoneScoreOrder source,String img) {
        if (null == source) return this;
        this.setOrderId(source.getItemId());
        this.setImg(img);
        this.setTargetTitle(source.getTargetTitle());
        this.setNumber(source.getNumber());
        this.setScore(source.getScore().intValue());
        this.setPrice(source.getPrice());
        this.setStatus(source.getStatus());
        this.setOrderCode(source.getOrderCode());
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getCreatedAt()));
        return this;
    }
}
