package com.liquidnet.service.goblin.dto.manage;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <p>
 * 预约表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@ApiModel(value = "GoblinGoodsAnticipateValueParam", description = "预约")
@Data
public class GoblinGoodsAnticipateValueParam{

    @ApiModelProperty(position = 11, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引无效")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 12, required = true, value = "每页显示记录数", example = "20")
    @Max(value = 100, message = "显示记录数无效")
    @NotNull(message = "显示记录数无效")
    private Integer pageSize;

    /**
     * 预约名称
     */
    @ApiModelProperty("sku名称")
    private String name;

    @ApiModelProperty(position = 18, required = false, value = "创建日期[yyyy-MM-dd]")
    private String createdDate;

}
