package com.liquidnet.service.consumer.order.service.processor;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyRespDto;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinTradeCommonBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerJsonNftPublishAndBuyProcessor
 * @Package com.liquidnet.service.consumer.order.service.processor
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/29 17:04
 */
@Slf4j
@Component
public class ConsumerGalaxyJsonNftPublishAndBuyProcessor {
    @Autowired
    private ZxinTradeCommonBiz zxinTradeCommonBiz;

    /**
     * 执行购买处理
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return zxinTradeCommonBiz.nftPublishAndBuy(reqDto);
    }
}
