package com.liquidnet.client.admin.zhengzai.admin.service.impl.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import gui.ava.html.Html2Image;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.imageio.ImageIO;
import javax.print.*;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.servlet.ServletOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * xx 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-15 6:57 下午
 */
@Component
public class CodeUtil {

    private static final Logger logger = LoggerFactory.getLogger(CodeUtil.class);

    public static String getQRCode(String content, int width, int height) {
        if (!StringUtils.isEmpty(content)) {
            ServletOutputStream stream = null;

            HashMap<EncodeHintType, Comparable> hints = new HashMap<>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 0);

            try {
                QRCodeWriter writer = new QRCodeWriter();
                BitMatrix bitMatrix = writer.encode(content, BarcodeFormat.QR_CODE, width, height, hints);

                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
//                ImageIO.write(bufferedImage, "png", os);

                String htmlPath = System.getProperty("user.dir").concat("/liquidnet-bus-client/liquidnet-client-admin/liquidnet-client-admin-zhengzai/src/main/java/com/liquidnet/client/admin/zhengzai/admin/service/impl/utils/tmphtml/qrcode/out.png");
                ImageIO.write(bufferedImage, "png", new File(htmlPath));
                return htmlPath;

//                BASE64Encoder encoder = new BASE64Encoder();
//                String resultImage = new String("data:image/png;base64," + encoder.encode(os.toByteArray()));
//
//                return resultImage;
            } catch (Exception e) {
            } finally {
                if (stream != null) {
                    try {
                        stream.flush();
                        stream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static String getBarCode(String content, int width, int height) {
        try {
            Map<EncodeHintType, Object> hints = new HashMap<>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 0);

            int realWidth = getBarCodeNoPaddingWidth(width, content, width);

            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.CODE_128, realWidth, height, hints);

            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
//            ImageIO.write(bufferedImage, "png", os);

            String htmlPath = System.getProperty("user.dir").concat("/liquidnet-bus-client/liquidnet-client-admin/liquidnet-client-admin-zhengzai/src/main/java/com/liquidnet/client/admin/zhengzai/admin/service/impl/utils/tmphtml/qrcode/out1.png");
            ImageIO.write(bufferedImage, "png", new File(htmlPath));
            return htmlPath;

//            BASE64Encoder encoder = new BASE64Encoder();
//            String resultImage = new String("data:image/png;base64," + encoder.encode(os.toByteArray()));

//            return resultImage;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 打印图片
     *
     * @param fileName
     * @param count
     */
    public static void drawImage(String fileName, int count) {
        FileInputStream fin = null;
        try {
            DocFlavor dof = null;
            if (fileName.endsWith(".gif")) {
                dof = DocFlavor.INPUT_STREAM.GIF;
            } else if (fileName.endsWith(".jpg")) {
                dof = DocFlavor.INPUT_STREAM.JPEG;
            } else if (fileName.endsWith(".png")) {
                dof = DocFlavor.INPUT_STREAM.PNG;
            }

            PrintService ps = PrintServiceLookup.lookupDefaultPrintService();

            PrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            pras.add(OrientationRequested.PORTRAIT);
            pras.add(new Copies(count));
            pras.add(PrintQuality.HIGH);

            DocAttributeSet das = new HashDocAttributeSet();
            // 设置打印纸张的大小（以毫米为单位）
            das.add(new MediaPrintableArea(0, 0, 210, 296, MediaPrintableArea.MM));

            fin = new FileInputStream(fileName);

            Doc doc = new SimpleDoc(fin, dof, das);

            DocPrintJob job = ps.createPrintJob();

            job.print(doc, pras);
            fin.close();
            logger.info("打印成功！文件：" + fileName + "数量为：" + count);
        } catch (IOException ie) {
            ie.printStackTrace();
        } catch (PrintException pe) {
            pe.printStackTrace();
        } finally {
            IOUtils.closeQuietly(fin);
        }
    }

    public static int getBarCodeNoPaddingWidth(int expectWidth, String contents, int maxWidth) {
        boolean[] code = new Code128Writer().encode(contents);

        int inputWidth = code.length;

        double outputWidth = (double) Math.max(expectWidth, inputWidth);
        double multiple = outputWidth / inputWidth;

        //优先取大的
        int returnVal = 0;
        int ceil = (int) Math.ceil(multiple);
        if (inputWidth * ceil <= maxWidth) {
            returnVal = inputWidth * ceil;
        } else {
            int floor = (int) Math.floor(multiple);
            returnVal = inputWidth * floor;
        }

        return returnVal;
    }

//    public static void html2img(String htmlstr)
    public static void html2img()
    {
        String qrCode = getQRCode("2453657424", 25, 25);
        System.out.println(qrCode);
        String barCode = getBarCode("2453657424", 90, 13);
        System.out.println(barCode);


        String htmlPath = System.getProperty("user.dir").concat("/liquidnet-bus-client/liquidnet-client-admin/liquidnet-client-admin-zhengzai/src/main/java/com/liquidnet/client/admin/zhengzai/admin/service/impl/utils/tmphtml/shunfeng1.html");
//        String replaceStr = htmlPath.replace("images/yiweima.png", barCode);
//        String replace = replaceStr.replace("images/erweima.png", qrCode);

        String html = "<!DOCTYPE html>\n" +
                "<html lang=\"en\">\n" +
                "<head>\n" +
                "\t<meta charset=\"utf-8\">\n" +
                "\t<meta name=\"renderer\" content=\"webkit\">\n" +
                "\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n" +
                "\t<meta http-equiv=\"Cache-Control\" content=\"no-transform\">\n" +
                "\t<meta http-equiv=\"Access-Control-Allow-Origin\" content=\"*\" />\n" +
                "\t<meta content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0\" name=\"viewport\">\n" +
                "\t<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n" +
                "\t<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black\" />\n" +
                "\t<meta name=\"format-detection\" content=\"telephone=yes\" /><!-- 点击链接打电话 -->\n" +
                "\t<meta name=\"format-detection\" content=\"address=no\" />\n" +
                "\t<meta name=\"keywords\" content=\"\">\n" +
                "\t<meta name=\"description\" content=\"\">\n" +
                "\t<link rel=\"icon\" type=\"image/png\" sizes=\"12x12\" href=\"https://img.zhengzai.tv/static/img/logo_small.png\">\n" +
                "</head>\n" +
                "<body>\n" +
                "\t<!-- 顺丰快递面单打印，尺寸：100mm*150mm模版 -->\n" +
                "\t<div\n" +
                "\t\tid=\"shunfeng-express\"\n" +
                "\t\tstyle=\"width: 96mm;\n" +
                "\t\t\theight: 150mm;\n" +
                "\t\t\tpadding-top: 5mm;\n" +
                "\t\t\tborder: 1px solid #000;\n" +
                "\t\t\ttext-align: center;\"\n" +
                "\t>\n" +
                "\t\t<!-- 1. 运单打印系统来源及时间等 -->\n" +
                "\t\t<div \n" +
                "\t\t\tclass=\"sourceAndPrintTime\"\n" +
                "\t\t\tstyle=\"width: 100%;\n" +
                "\t\t\t\tfont-family: 宋体;\n" +
                "\t\t\t\tfont-size: 4pt;\n" +
                "\t\t\t\tdisplay: flex;\n" +
                "\t\t\t\tflex-direction: row;\n" +
                "\t\t\t\tjustify-content: space-between;\n" +
                "\t\t\t\talign-items: flex-end;\"\n" +
                "\t\t>\n" +
                "\t\t\t<!-- 1.1 打印系统来源(太长放不下了，所以去掉了) -->\n" +
                "\t\t\t<!-- <div class=\"source\">\n" +
                "\t\t\t\tSCP顺丰云打印\n" +
                "\t\t\t</div> -->\n" +
                "\t\t\t<!-- 1.2 打印次数/时间 -->\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"printTime\"\n" +
                "\t\t\t\tstyle=\"width: 80%;\n" +
                "\t\t\t\t\tfont-family: 宋体;\n" +
                "\t\t\t\t\tfont-size: 4pt;\n" +
                "\t\t\t\t\tdisplay: flex;\n" +
                "\t\t\t\t\tflex-direction: row;\n" +
                "\t\t\t\t\tjustify-content: center;\n" +
                "\t\t\t\t\talign-items: flex-end;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t第一次打印 2020-05-05 12:00 第8/10个\n" +
                "\t\t\t</div>\n" +
                "\t\t\t<!-- 3  时效类型 -->\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"timeOfDeliveryType\"\n" +
                "\t\t\t\tstyle=\"font-family: 黑体;\n" +
                "\t\t\t\t\tfont-size: 18pt;\n" +
                "\t\t\t\t\tfont-weight: bolder;\n" +
                "\t\t\t\t\tmargin-right: 2mm;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t<!-- 3.1 特快即日、特快A、特快、标快、标快陆运、特惠、电商标快 -->\n" +
                "\t\t\t\t特快\n" +
                "\t\t\t</div>\n" +
                "\t\t</div>\n" +
                "\n" +
                "\n" +
                "\t\t<!-- 2. 条码区 -->\n" +
                "\t\t<div class=\"barCodeArea\">\n" +
                "\t\t\t<!-- 2.1 条码 -->\n" +
                "\t\t\t<div class=\"barCode\">\n" +
                "\t\t\t\t<img src=\"/usr/local/var/www/liquidnet-bus-v1/liquidnet-bus-client/liquidnet-client-admin/liquidnet-client-admin-zhengzai/src/main/java/com/liquidnet/client/admin/zhengzai/admin/service/impl/utils/tmphtml/qrcode/out1.png\" style=\"width: 90%; height: 13mm; margin: 0 5mm;\">\n" +
                "\t\t\t</div>\n" +
                "\t\t\t<!-- 2.2 子母件单号、汉字、件数标识、 -->\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"childAndParentParts\"\n" +
                "\t\t\t\tstyle=\"font-family: 黑体;\n" +
                "\t\t\t\t\tfont-size: 10pt;\n" +
                "\t\t\t\t\tdisplay: flex;\n" +
                "\t\t\t\t\tflex-direction: column;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t<div>\n" +
                "\t\t\t\t\t子单号：SF1 010 874 393 776\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t\t<div>\n" +
                "\t\t\t\t\t母单号：SF1 010 874 393 776\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t</div>\n" +
                "\t\t</div>\n" +
                "\n" +
                "\t\t<!-- 4\t目的地 -->\n" +
                "\t\t<!-- 4.1 路由信息  暂无-->\n" +
                "\t\t<div \n" +
                "\t\t\tclass=\"destinationArea\"\n" +
                "\t\t\tstyle=\"margin: 0 auto;\n" +
                "\t\t\t\tborder: 1px solid #000;\n" +
                "\t\t\t\tborder-bottom: none;\n" +
                "\t\t\t\twidth: 92mm;\"\n" +
                "\t\t>\n" +
                "\t\t\t<!-- 2.3 运单号 -->\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"expressNumber\"\n" +
                "\t\t\t\tstyle=\"font-size: 22pt; font-weight: bold;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t755W-BA-0123456789\n" +
                "\t\t\t</div>\n" +
                "\t\t\t<!-- 5\t收方信息 -->\t\n" +
                "\t\t\t<div class=\"destinationInfo\" style=\"text-align: left;\">\n" +
                "\t\t\t\t<!-- 5.1 收 -->\n" +
                "\t\t\t\t<div class=\"imgShou\" style=\"display: inline-block; width: 9mm; text-align: center;\">\n" +
                "\t\t\t\t\t<img src=\"images/iconShou.png\" style=\"width:7mm; height:7mm\">\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t\t<!-- 5.2 收件人姓名/电话/地址 -->\n" +
                "\t\t\t\t<div\n" +
                "\t\t\t\t\tclass=\"recipientInfo\"\n" +
                "\t\t\t\t\tstyle=\"display: inline-block; width: 62mm; font-family: 宋体; font-size: 9pt; text-align: left;\"\n" +
                "\t\t\t\t>\n" +
                "\t\t\t\t\t<div>\n" +
                "\t\t\t\t\t\t<span>收货姓名</span>\n" +
                "\t\t\t\t\t\t<span>18510980989</span>\n" +
                "\t\t\t\t\t</div>\n" +
                "\t\t\t\t\t<div>\n" +
                "\t\t\t\t\t\t<span>收货地址北京市朝阳区摩登天空测试地址</span>\n" +
                "\t\t\t\t\t</div>\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t\t<!-- 5.3 单元区域编码 暂无-->\n" +
                "\t\t\t\t<!-- 6\t代收货款 -->\n" +
                "\t\t\t\t<div class=\"iconCOD\" style=\"display: inline-block;\">\n" +
                "\t\t\t\t\t<!-- 6.1 COD -->\n" +
                "\t\t\t\t\t<img src=\"images/COD.jpg\" style=\"width: 17mm; height:9mm\">\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t</div>\n" +
                "\t\t</div>\n" +
                "\n" +
                "\t\t<table\n" +
                "\t\t\tclass=\"QrCodeArea\"\n" +
                "\t\t\tborder=\"1\"\n" +
                "\t\t\tstyle=\"margin: 0 auto; border: 1px solid #000; width: 92.5mm; border-collapse:collapse;\"\n" +
                "\t\t>\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<td class=\"daofuInfo\" style=\"font-family: 宋体; font-size: 9pt;\">\n" +
                "\t\t\t\t\t到付22元\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t\t<td rowspan=\"3\" class=\"QrCode\">\n" +
                "\t\t\t\t\t<img src=\"/usr/local/var/www/liquidnet-bus-v1/liquidnet-bus-client/liquidnet-client-admin/liquidnet-client-admin-zhengzai/src/main/java/com/liquidnet/client/admin/zhengzai/admin/service/impl/utils/tmphtml/qrcode/out.png\" style=\"width: 25mm; height: 25mm\">\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t\t<!-- 13\t已验视 -->\n" +
                "\t\t\t\t<td\n" +
                "\t\t\t\t\trowspan=\"3\"\n" +
                "\t\t\t\t\tclass=\"yiyanshiInfo\"\n" +
                "\t\t\t\t\tstyle=\"font-family: 黑体; font-size: 22pt; font-weight: bold; color: #272727b3; writing-mode: vertical-lr;\"\n" +
                "\t\t\t\t>\n" +
                "\t\t\t\t\t已验视\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t\t<!-- 产品名称\t限时限时KC24字段 -->\n" +
                "\t\t\t\t<td\n" +
                "\t\t\t\t\trowspan=\"2\"\n" +
                "\t\t\t\t\tclass=\"limitTime\"\n" +
                "\t\t\t\t\tstyle=\"font-family: 宋体; font-size: 12pt; width: 20mm;\"\n" +
                "\t\t\t\t>\n" +
                "\t\t\t\t\t限时\n" +
                "\t\t\t\t\tKC24\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<td rowspan=\"2\" class=\"jigangInfo\" style=\"font-family: 黑体; font-size: 22pt; font-weight: bold;\">\n" +
                "\t\t\t\t\tA22\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<td class=\"\">\n" +
                "\t\t\t\t\t1A\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t</table>\n" +
                "\n" +
                "\t\t<!-- 14\t寄方信息 -->\n" +
                "\t\t<div\n" +
                "\t\t\tclass=\"jiInfo\"\n" +
                "\t\t\tstyle=\"border-left: 1px solid #000;\n" +
                "\t\t\t\tborder-right: 1px solid #000;\n" +
                "\t\t\t\twidth: 92mm;\n" +
                "\t\t\t\tmargin: 0 auto;\n" +
                "\t\t\t\ttext-align: left;\"\n" +
                "\t\t>\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"imgShou\"\n" +
                "\t\t\t\tstyle=\"display: inline-block; width: 9mm; text-align: center;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t<img src=\"images/iconJi.png\" style=\"width:7mm; height:7mm\">\n" +
                "\t\t\t</div>\n" +
                "\t\t\t<!-- 14.1 寄件人人姓名/电话/地址 -->\n" +
                "\t\t\t<div\n" +
                "\t\t\t\tclass=\"recipientInfo\" \n" +
                "\t\t\t\tstyle=\"display: inline-block; width: 62mm; font-family: 宋体; font-size: 9pt; text-align: left;\"\n" +
                "\t\t\t>\n" +
                "\t\t\t\t<div>\n" +
                "\t\t\t\t\t<span>寄件人姓名</span>\n" +
                "\t\t\t\t\t<span>18510980989</span>\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t\t<div>\n" +
                "\t\t\t\t\t<span>寄件地址北京市朝阳区摩登天空测试地址</span>\n" +
                "\t\t\t\t</div>\n" +
                "\t\t\t</div>\n" +
                "\t\t</div>\n" +
                "\t\t\n" +
                "\t\t<table\n" +
                "\t\t\tclass=\"otherInfo\"\n" +
                "\t\t\tborder=\"1\"\n" +
                "\t\t\tstyle=\"\n" +
                "\t\t\t\tmargin: 0 auto;\n" +
                "\t\t\t\tborder: 1px solid #000;\n" +
                "\t\t\t\twidth: 92.5mm;\n" +
                "\t\t\t\tfont-family: 宋体;\n" +
                "\t\t\t\tfont-size: 9pt;\n" +
                "\t\t\t\ttext-align: left;\n" +
                "\t\t\t\tborder-collapse:collapse;\"\n" +
                "\t\t>\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<!-- 15\t托寄物 -->\n" +
                "\t\t\t\t<td rowspan=\"2\">\n" +
                "\t\t\t\t\t托寄物：\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t\t<!-- 16\t增值服务 -->\n" +
                "\t\t\t\t<td>\n" +
                "\t\t\t\t\t增值服务：\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t\t<!-- 17\t其他信息 -->\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<!-- 17. 1重量 -->\n" +
                "\t\t\t\t<!-- 17.2 付款方式、费用等 -->\n" +
                "\t\t\t\t<td>\n" +
                "\t\t\t\t\t<div>计费重量：1kg</div>\n" +
                "\t\t\t\t\t<div>实际重量： 1kg</div>\n" +
                "\t\t\t\t\t<div>费用合计：22元</div>\n" +
                "\t\t\t\t\t<div>付款方式：寄付现结</div>\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t\t<tr>\n" +
                "\t\t\t\t<!-- 18\t客户自定义区 -->\n" +
                "\t\t\t\t<td>\n" +
                "\t\t\t\t\t客户自定义区\n" +
                "\t\t\t\t\t备注\n" +
                "\t\t\t\t\t转寄协议客户\n" +
                "\t\t\t\t\t订单等信息\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t\t<!-- 19\t图标区域 -->\n" +
                "\t\t\t\t<td>\n" +
                "\t\t\t\t\t图标区域\n" +
                "\t\t\t\t\t贴纸信息\n" +
                "\t\t\t\t</td>\n" +
                "\t\t\t</tr>\n" +
                "\t\t</table>\n" +
                "\t\t\n" +
                "\t</div>\n" +
                "</body>\n" +
                "\n" +
                "\n" +
                "</html>";
        Html2Image html2Image = Html2Image.fromHtml(html);
        html2Image.getImageRenderer().saveImage("/Users/jiangxiulong/Desktop/aaa.png");
    }

    public static void main(String[] args) {
        html2img();
        // 打印图片
        drawImage("/Users/jiangxiulong/Desktop/aaa.png", 1);
    }

}
