package com.liquidnet.client.admin.zhengzai.sweet.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.utils.DictUtils;
import com.liquidnet.service.sweet.dto.SweetActivityDrawListDao;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetActivityDrawExcelListDao implements Serializable, Cloneable {

    private static final long serialVersionUID = -3918944925598231439L;

    @Excel(name = "奖品名称")
    private String prizeTitle;

    @Excel(name = "奖品类型")
    private String prizeName;

    @Excel(name = "数量")
    private Integer prizeTypeNum;

    @Excel(name = "用户昵称")
    private String nickname;

    @Excel(name = "用户手机号")
    private String mobile;

    @Excel(name = "收货人姓名")
    private String receivingName;

    @Excel(name = "收货人手机号")
    private String receivingPhone;

    @Excel(name = "收货地址")
    private String receivingAddressAll;

    @Excel(name = "发放状态")
    private String receivingStatusName;

    private LocalDateTime createdAt;

    private static final SweetActivityDrawExcelListDao obj = new SweetActivityDrawExcelListDao();

    public static SweetActivityDrawExcelListDao getNew() {
        try {
            return (SweetActivityDrawExcelListDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetActivityDrawExcelListDao();
        }
    }

    public SweetActivityDrawExcelListDao copy(SweetActivityDrawListDao source) {
        if (null == source) return this;
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeName(DictUtils.getDictLabel("zhengzai_sweet_draw_prize_type", String.valueOf(source.getPrizeType())));
        this.setPrizeTypeNum(source.getPrizeTypeNum());
        this.setNickname(source.getNickname());
        this.setReceivingName(source.getReceivingName());
        this.setReceivingPhone(source.getReceivingPhone());
        this.setReceivingAddressAll(source.getReceivingAddressAll());
        if (source.getReceivingStatus() == 2) {
            this.setReceivingStatusName("已发放");
        } else {
            this.setReceivingStatusName("未发放");
        }
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }
}
