package com.liquidnet.service.dragon.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.service.IDragonOrderRefundsService;
import com.liquidnet.service.dragon.utils.PayUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;

@Service
public class DragonOrderRefundsServiceImpl implements IDragonOrderRefundsService {

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Override
    public void sendRedisQueue() {
//        try {
//            HashMap<String ,String> map = new HashMap<>();
//            map.put("message","测试 redis 订阅信息1");
//            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey("dragon-refund");
//            stringRedisTemplate.opsForStream().add(record);
//        }catch (Exception e){
//            e.printStackTrace();
//        }

        try {
            PayUtils payUtils = new PayUtils();
            HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi");
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");

            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectMapper objectMapper = new ObjectMapper();

            ObjectNode rootNode = objectMapper.createObjectNode();
            rootNode.put("mchid", "1551961491")
                    .put("appid", "wx3498304dda39c5a1")
                    .put("description", "Image形象店-深圳腾大-QQ公仔")
                    .put("notify_url", "https://www.weixin.qq.com/wxpay/pay.php")
                    .put("out_trade_no", "1217752501201407033233368018");
            rootNode.putObject("amount")
                    .put("total", 1);
            rootNode.putObject("payer")
                    .put("openid", "oUpF8uMuAJO_M2pxb1Q9zNjWeS6o");

            objectMapper.writeValue(bos, rootNode);

            httpPost.setEntity(new StringEntity(bos.toString("UTF-8"), "UTF-8"));
            CloseableHttpResponse response = payUtils.getHttpClient().execute(httpPost);

            String bodyAsString = EntityUtils.toString(response.getEntity());
            System.out.println(bodyAsString);

        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
