package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftBuyPayResultQueryReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 11:23
 */
@ApiModel(value = "GalaxyNftBuyPayResultQueryReqDto", description = "NFT购买支付结果查询")
@Data
public class GalaxyNftBuyPayResultQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * nftOrderPayId
     */
    @ApiModelProperty(position = 1, required = true, value = "nft订单支付id(保证唯一)，不超过30个字符")
    @NotBlank(message = "nft订单支付id不能为空")
    @Size(min = 2, max = 30, message = "nft订单支付id限制2-30位且不能包含特殊字符")
    private String nftOrderPayId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftBuyPayResultQueryReqDto obj = new GalaxyNftBuyPayResultQueryReqDto();

    public static GalaxyNftBuyPayResultQueryReqDto getNew() {
        try {
            return (GalaxyNftBuyPayResultQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftBuyPayResultQueryReqDto();
        }
    }
}
