package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.AdamEntersParam;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.service.IAdamEntersService;
import com.liquidnet.service.adam.service.IAdamRdmService;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.SqlMapping;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

/**
 * <p>
 * 入场人 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Slf4j
@Service
public class AdamEntersServiceImpl implements IAdamEntersService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IAdamRdmService adamRdmService;

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public String add(AdamEntersParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        List<AdamEntersVo> vos = adamRdmService.getEntersVoByUid(currentUid);

        AdamEntersVo vo = AdamEntersVo.getNew();
        BeanUtils.copyProperties(parameter, vo);
        vo.setEntersId(String.valueOf(IDGenerator.nextSnowId()));
        vo.setUid(currentUid);
        vo.setIsDefault(CollectionUtils.isEmpty(vos));
        vo.setState(1);
        vo.setCreatedAt(nowStr);

        mongoTemplate.insert(vo, AdamEntersVo.class.getSimpleName());

        rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get("adam_enters.add",
                        vo.getEntersId(), vo.getUid(), vo.getType(), vo.getName(), vo.getMobile(), vo.getIdCard(), vo.getIsDefault(), vo.getState(), now
                )
        );

        adamRdmService.delEntersVoByUid(currentUid);

        return vo.getEntersId();
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void def(String uid, String entersId) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        LinkedList<Object[]> toMqObjs = new LinkedList<>();
        List<AdamEntersVo> vos = adamRdmService.getEntersVoByUid(uid);
        if (vos.size() > 1) {// 取消原默认
            AdamEntersVo unDeaultVo = AdamEntersVo.getNew();
            unDeaultVo.setIsDefault(false);
            unDeaultVo.setUpdatedAt(nowStr);
            Document doc = mongoTemplate.getCollection(AdamEntersVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("uid").is(uid).and("state").is(1).and("isDefault").is(true)).getQueryObject(),
                    new Document("$set", Document.parse(JsonUtils.toJson(unDeaultVo))),
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );
            if (null != doc) {
                AdamEntersVo unDeaultVoAfter = BsonUtil.toBean(doc, AdamEntersVo.class);

                toMqObjs.add(new Object[]{unDeaultVo.getIsDefault(), now, unDeaultVoAfter.getEntersId()});

//                vos.removeIf(r -> r.getEntersId().equals(unDeaultVoAfter.getEntersId()));
//                vos.add(unDeaultVoAfter);
                vos = this.collectionProcess(vos, unDeaultVoAfter.getEntersId(), unDeaultVoAfter);
            }
        }
        {// 设置新默认
            AdamEntersVo defaultVo = AdamEntersVo.getNew();
            defaultVo.setIsDefault(true);
            defaultVo.setUpdatedAt(nowStr);
            Document doc = mongoTemplate.getCollection(AdamEntersVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("uid").is(uid).and("entersId").is(entersId)).getQueryObject(),
                    new Document("$set", Document.parse(JsonUtils.toJson(defaultVo))),
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );
            if (null != doc) {
                AdamEntersVo defaultVoAfter = BsonUtil.toBean(doc, AdamEntersVo.class);

                toMqObjs.add(new Object[]{defaultVo.getIsDefault(), now, entersId});

//                vos.removeIf(r -> r.getEntersId().equals(defaultVoAfter.getEntersId()));
//                vos.add(defaultVoAfter);
                vos = this.collectionProcess(vos, defaultVoAfter.getEntersId(), defaultVoAfter);
            }
        }
        if (!CollectionUtils.isEmpty(toMqObjs)) {
            rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_enters.update.is_default", toMqObjs));
            adamRdmService.setEntersVoByUid(uid, vos);
        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void edit(AdamEntersParam parameter) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);

        AdamEntersVo updateVo = AdamEntersVo.getNew();
        BeanUtils.copyProperties(parameter, updateVo);
        updateVo.setUpdatedAt(nowStr);
        Document doc = mongoTemplate.getCollection(AdamEntersVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("entersId").is(parameter.getEntersId())).getQueryObject(),
                new Document("$set", Document.parse(JsonUtils.toJson(updateVo))),
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        if (null != doc) {
            updateVo = BsonUtil.toBean(doc, AdamEntersVo.class);
            rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_enters.edit",
                            updateVo.getType(), updateVo.getName(), updateVo.getMobile(), updateVo.getIdCard(), updateVo.getIsDefault(), updateVo.getState(), now, updateVo.getEntersId()
                    )
            );

            String currentUid = CurrentUtil.getCurrentUid();

            List<AdamEntersVo> vos = adamRdmService.getEntersVoByUid(currentUid);
//            vos.removeIf(r -> r.getEntersId().equals(parameter.getEntersId()));
//            vos.add(updateVo);
            adamRdmService.setEntersVoByUid(currentUid, this.collectionProcess(vos, parameter.getEntersId(), updateVo));
        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void remove(String uid, String entersId) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.Formatter.yyyyMMddHHmmss.format(now);


        AdamEntersVo removeVo = AdamEntersVo.getNew();
        removeVo.setState(2);
        removeVo.setIsDefault(false);
        removeVo.setUpdatedAt(nowStr);
        removeVo.setDeletedAt(nowStr);

        Document doc = mongoTemplate.getCollection(AdamEntersVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("entersId").is(entersId)).getQueryObject(),
                new Document("$set", Document.parse(JsonUtils.toJson(removeVo))),
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        if (null != doc) {
            rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                    SqlMapping.get("adam_enters.remove", now, now, entersId)
            );

            List<AdamEntersVo> vos = adamRdmService.getEntersVoByUid(uid);
            vos.removeIf(r -> r.getEntersId().equals(entersId));
            adamRdmService.setEntersVoByUid(uid, vos);
        }
    }

    @Override
    public AdamEntersVo queryDefault(String uid) {
        List<AdamEntersVo> vos = adamRdmService.getEntersVoByUid(uid);

        if (!CollectionUtils.isEmpty(vos)) {
            AdamEntersVo defaultVo = null;
            for (AdamEntersVo vo : vos) {
                if (vo.getIsDefault()) {
                    return vo;
                }
                defaultVo = null == defaultVo ? vo :
                        vo.getCreatedAt().compareTo(defaultVo.getCreatedAt()) > 0 ? vo : defaultVo;
            }
            return defaultVo;
        }
        return null;
    }

    /* ---------------------------------------------------------------  */

    private List<AdamEntersVo> collectionProcess(List<AdamEntersVo> vos, String replaceId, AdamEntersVo updateVo) {
        int idx = IntStream.range(0, vos.size())
                .filter(i -> vos.get(i).getEntersId().equals(replaceId))
                .findFirst().orElse(-1);
        if (idx == -1) {
            adamRdmService.delEntersVoByUid(updateVo.getUid());

            List<AdamEntersVo> entersVos = adamRdmService.getEntersVoByUid(updateVo.getUid());

            idx = IntStream.range(0, vos.size())
                    .filter(i -> entersVos.get(i).getEntersId().equals(replaceId))
                    .findFirst().orElse(-1);

            if (idx == -1) {
                ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10017");
                throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
            }
        }
        vos.set(idx, updateVo);
        return vos;
    }
}
