package com.liquidnet.service.goblin.controller;

import com.alibaba.fastjson.JSON;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontController {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @GetMapping("getBanner")
    @ApiOperation("获取banner")
    public ResponseDto getBanner() {
        //redis里获取banner
        return ResponseDto.success(  redisDataSourceUtil.getRedisGoblinUtil().get(GoblinRedisConst.FRONT_BANNER+"0"));
    }
}
