package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyArtSeriesClaimRespDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 11:21
 */
@ApiModel(value = "GalaxyArtSeriesClaimRespDto", description = "NFT系列声明返回结果")
@Data
public class GalaxyArtSeriesClaimRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "skuId")
    private String skuId;

    @ApiModelProperty(position = 2, required = true, value = "素材访问地址")
    private String materialAccessUrl;

    @ApiModelProperty(position = 3, required = true, value = "系列在区块链上唯一ID")
    private String seriesId;

    @ApiModelProperty(position = 3, required = true, value = "系列在区块链上的名称")
    private String seriesName;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyArtSeriesClaimRespDto obj = new GalaxyArtSeriesClaimRespDto();

    public static GalaxyArtSeriesClaimRespDto getNew() {
        try {
            return (GalaxyArtSeriesClaimRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyArtSeriesClaimRespDto();
        }
    }
}