package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftBuyRespDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 18:13
 */
@ApiModel(value = "GalaxyNftBuyRespDto", description = "NFT购买")
@Data
public class GalaxyNftBuyRespDto implements Serializable,Cloneable {
    private String userId;

    private String nftId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftBuyRespDto obj = new GalaxyNftBuyRespDto();

    public static GalaxyNftBuyRespDto getNew() {
        try {
            return (GalaxyNftBuyRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftBuyRespDto();
        }
    }
}
