package com.liquidnet.service.feign.kylin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-platform",
        contextId = "FeignPlatformTaskClient", path = "",
        url = "${liquidnet.service.platform.url}",
//        url = "",
        fallback = FallbackFactory.Default.class)
public interface FeignPlatformTaskClient {

    @PostMapping("platform/order/checkOrderTime")
    ResponseDto<Boolean> checkOrderTime();

    @PostMapping("platform/performance/checkPerformanceTime")
    ResponseDto<String> checkPerformanceTime();

    @PostMapping("platform/order/checkTransferOrder")
    ResponseDto<Boolean> checkTransferOrder(@RequestParam("minute") Integer minute);

    @PostMapping("platform/order/goblin/checkOrderTime")
    ResponseDto<Boolean> checkGoblinOrderTime();
}
