package com.liquidnet.service.kylin.controller.admin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderRefundDao;
import com.liquidnet.service.kylin.dto.vo.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinOrderRefundsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 后台单订单退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 10:58 上午
 */

@Api(tags = "后端-单订单退款")
@RestController
@RequestMapping("admin/refund")

public class KylinOrderRefundAdminController {

    @Autowired
    private KylinOrderRefundsServiceImpl kylinOrderRefundsServiceImpl;

    @GetMapping("{orderRefundId}")
    @ApiOperation("详情")
    @ApiImplicitParam(type = "path", dataType = "String", name = "orderRefundId", value = "主键id", required = true)
    public ResponseDto<KylinOrderRefundsVo> detail(@PathVariable("orderRefundId") String orderRefundId) {
        KylinOrderRefundsVo result = null;
        result = kylinOrderRefundsServiceImpl.detail(orderRefundId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取详情失败");
        }
    }

    @GetMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "每页数量")
    })
    public ResponseDto<PageInfo<OrderRefundDao>> bannerList(
            @RequestParam(defaultValue = "1") Integer page,
            @RequestParam(defaultValue = "10") Integer size
    ) {
        PageInfo<OrderRefundDao> result = null;
        result = kylinOrderRefundsServiceImpl.refundList(page, size);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取列表失败");
        }
    }

    @PostMapping("apply")
    @ApiOperation("申请退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderTicketsId", value = "订单id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderRefundBatchesId", value = "批量id"),
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundData", value = "退款数据"),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reason", value = "备注", required = true)
    })
    public ResponseDto<Object> refundApply(
            @RequestBody String orderTicketsId,
            @RequestBody String orderRefundBatchesId,
            @RequestBody String refundData,
            @RequestBody String reason
    ) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundApply(orderTicketsId, reason, orderRefundBatchesId, refundData);
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("申请退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    @PostMapping("cancel")
    @ApiOperation("取消退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "Lsit", name = "orderRefundsIdList", value = "退款id 支持批量", required = true)
    })
    public ResponseDto<Object> refundApply(
            @RequestBody List orderRefundsIdList
    ) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundCancel(orderRefundsIdList);
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("取消退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    @PostMapping("reapply")
    @ApiOperation("再次提交审核")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "Lsit", name = "orderRefundsIdList", value = "退款id 支持批量", required = true)
    })
    public ResponseDto<Object> refundReapply(
            @RequestBody List orderRefundsIdList
    ) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundReapply(orderRefundsIdList);
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("再次申请退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    @PostMapping("review")
    @ApiOperation("一审运营 审核/驳回")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "Lsit", name = "orderRefundsIdList", value = "退款id 支持批量", required = true),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "status", value = "批量id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reject", value = "备注", required = true)
    })
    public ResponseDto<Object> refundReview(
            @RequestBody List orderRefundsIdList,
            @RequestBody Integer status,
            @RequestBody String reject
    ) {
        try {
            Boolean res = false;
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED) { // 通过
                res = kylinOrderRefundsServiceImpl.refundApproved(orderRefundsIdList, reject);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT) { // 驳回
                res = kylinOrderRefundsServiceImpl.refundReject(orderRefundsIdList, reject);
            }
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("审核退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    @PostMapping("execute")
    @ApiOperation("二审财务 审核(执行退款)/驳回")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "Lsit", name = "orderRefundsIdList", value = "退款id 支持批量", required = true),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "status", value = "批量id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "refuse", value = "备注", required = true)
    })
    public ResponseDto<Object> refundExecute(
            @RequestBody List orderRefundsIdList,
            @RequestBody Integer status,
            @RequestBody String refuse
    ) {
        try {
            Boolean res = false;
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_UNFILLED) { // 通过
                res = kylinOrderRefundsServiceImpl.refundUnfilled(orderRefundsIdList, refuse);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE) { // 驳回
                res = kylinOrderRefundsServiceImpl.refundRefuse(orderRefundsIdList, refuse);
            }
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("审核退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    //    @PostMapping("refundCompleted")
//    @ApiOperation("主动关闭订单，完成退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "orderRefundsId", value = "退款id", required = true)
    })
    public ResponseDto<Object> refundCompleted(
            @RequestBody Integer orderRefundsId
    ) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundCompleted(orderRefundsId);
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("关闭订单失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

}
