package com.liquidnet.service.feign.adam.admin.company;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.query.AdamComInfoQuery;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_ADMIN_COMPANY)
public interface FeignAdminAdamComInfoClient {

    @RequestMapping(value = "/admin/adam-com-info/query_list")
    ResponseDto<Page<AdamComInfo>> queryList(@RequestBody AdamComInfoQuery query,
                                             @RequestParam int pageNum,
                                             @RequestParam int pageSize);

}
