package com.liquidnet.service.goblin.dto.manage.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtGoodsVo", description = "商品管理:商品列表信息")
@Data
public class GoblinStoreMgtGoodsListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5926827517337445529L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[45]")
    private String spuNo;
    @ApiModelProperty(position = 12, value = "商品类型[0-常规|1-数字藏品]")
    private int spuType;
    @ApiModelProperty(position = 13, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 14, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 15, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 16, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 17, value = "商品三级分类ID[30]")
    private String cateTid;
    @ApiModelProperty(position = 18, value = "价格区间MIN")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 19, value = "价格区间MAX")
    private BigDecimal priceLe;
    @ApiModelProperty(position = 20, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 21, value = "审核拒绝原因")
    private String reason;
    @ApiModelProperty(position = 22, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;

    @ApiModelProperty(position = 23, value = "总库存")
    private Integer totalStock;
    @ApiModelProperty(position = 24, value = "剩余库存")
    private Integer surplusStock;
    @ApiModelProperty(position = 25, value = "库存不足预警值")
    private Integer warningStock;
    @ApiModelProperty(position = 25, value = "关联活动标记[0-未关联|1-已关联]，用于下架提示'商品正在参与活动，是否确认下架？'")
    private Integer relateMarket;
}
