package com.liquidnet.service.adam.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.mapper.AdamRealNameMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class DMRealNameProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamRealNameMapper realNameMapper;

    @SneakyThrows
    @Override
    protected void dataProcessing(boolean flg) {
        String sqlCount = "select count(1) from user_real_name where 1=1";
        String field = "id,uid,real_name,id_card,created_at,updated_at";
//                     1-id,2-uid,3-real_name,4-id_card,5-created_at,6-updated_at
        String sql = sqlCount.replace("count(1)", field);

        if (flg) {
            sqlCount += " and uid in ('2026628','544327','1997335','773650','809406')";
            sql += " and uid in ('2026628','544327','1997335','773650','809406')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 2, num = 0;
        log.info("DM数据迁移总数:{}", ct);


        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            statement.setInt(1, pSize * num);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);
            while (row.next()) {
                String uid = row.getString(2);

                if (!reUidList.contains(uid)) {
                    AdamRealName realName = new AdamRealName();
                    realName.setRealNameId(row.getString(1));
                    realName.setUid(uid);
                    realName.setType("1");
                    realName.setName(row.getString(3));
                    realName.setIdCard(row.getString(4));
                    realName.setState(1);
                    realName.setCreatedAt(row.getLocalDateTime(5));
                    realName.setUpdatedAt(row.getLocalDateTime(6));

                    AdamRealInfoVo vo = AdamRealInfoVo.getNew();
                    vo.setName(realName.getName());
                    vo.setIdCard(realName.getIdCard());
                    vo.setState(1);

                    realNameMapper.insert(realName);
                    mongoTemplate.insert(vo, AdamRealInfoVo.class.getSimpleName());
                }
            }


            num++;
            ct -= pSize;
        }
    }
}
