/**
 * $Id: PayExceptionManager.java 13261 2016-07-06 02:22:54Z huangcheng $
 * Copyright(C) 2014-2020 netease - easegame, All Rights Reserved.
 */
package com.liquidnet.common.exception.constant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 *
 * @author <a href="mailto:huangcheng@liquidnet.com">Huang Cheng</a>
 * @version 1.0 2016年4月22日 下午8:52:21
 */
public class PayExceptionManager {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 获取exception对象
	 * @param clazz
	 * @param logMsg
	 * @param params
	 * @param <T>
	 * @return
	 */
	public static <T> T getException(Class<T> clazz, String logMsg, Object... params) {
//		PayExceptionManager.log(logMsg, params);
		try {
			Constructor<T> constructor = clazz.getConstructor();
			T t = constructor.newInstance();
			return t;
		} catch (NoSuchMethodException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception NoSuchMethodException", e);
		} catch (SecurityException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception SecurityException", e);
		}catch (InstantiationException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception InstantiationException", e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception IllegalAccessException", e);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception IllegalArgumentException", e);
		} catch (InvocationTargetException e) {
			throw new RuntimeException("get com.liquidnet.service.p2m.ext.exception InvocationTargetException", e);
		}
	}

//	/**
//	 * 记录异常的日志输出
//	 * @param logMsg
//	 * @param params
//	 */
//	private static void log(String logMsg, Object... params) {
//		String msg = StringUtil.isNotEmpty(logMsg) ? logMsg : "logMsg is null";
//		msg += " : " + StringUtil.joinArray(", ", params);
//        logger.error("log error: {}",msg);
//	}
}
