package com.liquidnet.service.kylin.service.impl;

import com.alibaba.fastjson.JSON;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.vo.mongo.*;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.OrderUtils;
import com.liquidnet.service.kylin.utils.QueueUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private OrderUtils orderUtils;
    @Autowired
    private QueueUtils queueUtils;

    public Boolean orderTicketRefunding(
            KylinOrderTicketVo orderInfo, String orderTicketsId,
            double RefundPriceExpress,
            List<String> ticketEntityIds, List<Double> entitiesPrice
    ) {
        if (CollectionUtil.isEmpty(ticketEntityIds)) {
            return false;
        }
        // 基础数据
        String authId = "";
        String authName = "system_overtime_order_refund";
        String reason = "订单支付超时自动退款";
        // 本次退款票总金额
        double entitiesPriceSum = entitiesPrice.stream().mapToDouble(Double::doubleValue).sum();

        // 更新数据
        // 订单状态表 和 缓存
        LocalDateTime nowTime = LocalDateTime.now();
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(nowTime);
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        orderStatusTable.setUpdatedAt(nowTime);

        /*kylinOrderTicketStatusMapper.update(orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                .eq("order_id", orderTicketsId));*/

        KylinOrderTicketVo kylinOrderTicketVo = KylinOrderTicketVo.getNew();
        kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        kylinOrderTicketVo.setUpdatedAt(nowTimeStr);
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
        UpdateResult orderResult = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderObject
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        orderUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);


        // 订单入场人表 和 缓存
        KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
        entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
        entitiesTable.setUpdatedAt(nowTime);

        KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = KylinOrderTicketEntitiesVo.getNew();
        kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
        kylinOrderTicketEntitiesVo.setUpdatedAt(nowTimeStr);
        BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));

        LinkedList<Object[]> sqlsDataB = CollectionUtil.linkedListObjectArr();
        for (String v : ticketEntityIds) {
            sqlsDataB.add(new Object[]{
                    entitiesTable.getIsPayment(), entitiesTable.getUpdatedAt(), v, orderInfo.getChangeDate(), orderInfo.getChangeDate()
            });
            /*kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", v));*/

            UpdateResult entitiesResult = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(v)).getQueryObject(),
                    entitiesObject
            );
            dataUtils.delOrderTicketEntitiesRedis(v);
        }

        // 退款明细
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        String orderRefundsId = IDGenerator.nextSnowId();
        kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
        kylinOrderRefunds.setOrderTicketsId(orderTicketsId);
        String orderRefundCode = orderInfo.getOrderCode();
        String codeNum = StringUtils.leftPad(String.valueOf(5), 3, "0");
        kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
        kylinOrderRefunds.setPrice(BigDecimal.valueOf(entitiesPriceSum));
        kylinOrderRefunds.setPriceExpress(BigDecimal.valueOf(RefundPriceExpress));
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
        kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_AUTO);
        kylinOrderRefunds.setApplicantId(authId);
        kylinOrderRefunds.setApplicantName(authName);
        kylinOrderRefunds.setApplicantAt(nowTime);
        kylinOrderRefunds.setReason(reason);
        if (RefundPriceExpress > 0 && entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
        } else if (RefundPriceExpress > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
        } else if (entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
        }
        kylinOrderRefunds.setCreatedAt(nowTime);

        /*int rows = kylinOrderRefundsMapper.insert(kylinOrderRefunds);*/

        KylinOrderRefundsVo orderRefundsVo = KylinOrderRefundsVo.getNew();
        BeanUtils.copyProperties(kylinOrderRefunds, orderRefundsVo);
        mongoTemplate.insert(orderRefundsVo, KylinOrderRefundsVo.class.getSimpleName());

        // 退款入场人表
        KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
        kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
        kylinOrderRefundEntities.setCreatedAt(LocalDateTime.now());
        LinkedList<Object[]> sqlsDataD = CollectionUtil.linkedListObjectArr();
        for (int i = 0; i <= ticketEntityIds.size() - 1; i++) {
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(entitiesPrice.get(i)));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(ticketEntityIds.get(i));

            sqlsDataD.add(new Object[]{
                    kylinOrderRefundEntities.getOrderRefundsEntitiesId(), kylinOrderRefundEntities.getOrderRefundsId(), kylinOrderRefundEntities.getRefundPrice(),
                    kylinOrderRefundEntities.getOrderTicketEntitiesId(), kylinOrderRefundEntities.getCreatedAt()
            });
            /*int rowsR = kylinOrderRefundsEntitiesMapper.insert(kylinOrderRefundEntities);*/

            KylinOrderRefundEntitiesVo orderRefundEntitiesVo = KylinOrderRefundEntitiesVo.getNew();
            BeanUtils.copyProperties(kylinOrderRefundEntities, orderRefundEntitiesVo);
            mongoTemplate.insert(orderRefundEntitiesVo, KylinOrderRefundEntitiesVo.class.getSimpleName());
        }

        //mq更改数据库
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsDataC = CollectionUtil.linkedListObjectArr();

        sqls.add(SqlMapping.get("kylin_order_ticket_status.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_ticket_entities.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_refund.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_refund_entities.overtimeRefund"));

        sqlsDataA.add(new Object[]{
                orderStatusTable.getStatus(), orderStatusTable.getUpdatedAt(), orderInfo.getOrderTicketsId(), orderInfo.getChangeDate(), orderInfo.getChangeDate()
        });

        sqlsDataC.add(new Object[]{
                kylinOrderRefunds.getOrderRefundsId(), kylinOrderRefunds.getOrderTicketsId(), kylinOrderRefunds.getOrderRefundCode(),
                kylinOrderRefunds.getPrice(), kylinOrderRefunds.getPriceExpress(), kylinOrderRefunds.getStatus(),
                kylinOrderRefunds.getType(), kylinOrderRefunds.getApplicantId(), kylinOrderRefunds.getApplicantName(),
                kylinOrderRefunds.getApplicantAt(), kylinOrderRefunds.getReason(),
                kylinOrderRefunds.getRefundCate(), kylinOrderRefunds.getCreatedAt()
        });

        queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_OVERTIME_REFUND.getKey(),
                SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD));

        return true;
    }


    public String userOrderTicketRefunding(
            KylinOrderTicketVo orderInfo,
            double refundPrice,
            String orderEntitiesId,
            String reason,
            String picList,
            String uid,
            String username,
            int refundCount
    ) {
        try {
            LocalDateTime time = LocalDateTime.now();
            String strTime = DateUtil.Formatter.yyyyMMddHHmmss.format(time);
            // 订单状态表 和 缓存
            KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
            orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
            orderStatusTable.setUpdatedAt(time);


            KylinOrderTicketVo kylinOrderTicketVo = KylinOrderTicketVo.getNew();
            kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
            kylinOrderTicketVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(time));
            BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
            mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketsId").is(orderInfo.getOrderTicketsId())).getQueryObject(),
                    orderObject
            );
            dataUtils.delOrderTicketRedis(orderInfo.getOrderTicketsId());
            orderUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderInfo.getOrderTicketsId(), null);


            // 订单入场人表 和 缓存
            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            entitiesTable.setUpdatedAt(time);


            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = KylinOrderTicketEntitiesVo.getNew();
            kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            kylinOrderTicketEntitiesVo.setUpdatedAt(strTime);
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(orderEntitiesId)).getQueryObject(),
                    entitiesObject
            );
            dataUtils.delOrderTicketEntitiesRedis(orderEntitiesId);

            // 退款明细
            KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
            String orderRefundsId = IDGenerator.nextSnowId();
            kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
            kylinOrderRefunds.setOrderTicketsId(orderInfo.getOrderTicketsId());
            String orderRefundCode = orderInfo.getOrderCode();
            String codeNum = StringUtils.leftPad(String.valueOf(refundCount), 3, "0");
            kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
            kylinOrderRefunds.setPrice(BigDecimal.valueOf(refundPrice));
            kylinOrderRefunds.setPriceExpress(orderInfo.getPriceExpress());
            kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
            kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY);
            kylinOrderRefunds.setApplicantId(uid);
            kylinOrderRefunds.setApplicantName(username);
            kylinOrderRefunds.setApplicantAt(time);
            kylinOrderRefunds.setReason(reason);
            if (orderInfo.getPriceExpress().doubleValue() > 0 && refundPrice > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
            } else if (orderInfo.getPriceExpress().doubleValue() > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
            } else if (refundPrice > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
            }
            kylinOrderRefunds.setCreatedAt(time);

            KylinOrderRefundsVo orderRefundsVo = KylinOrderRefundsVo.getNew();
            BeanUtils.copyProperties(kylinOrderRefunds, orderRefundsVo);
            orderRefundsVo.setCreatedAt(time);
            orderRefundsVo.setApplicantAt(time);
            mongoTemplate.insert(orderRefundsVo, KylinOrderRefundsVo.class.getSimpleName());


            // 退款入场人表
            KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(refundPrice));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(orderEntitiesId);
            kylinOrderRefundEntities.setCreatedAt(time);

            KylinOrderRefundEntitiesVo orderRefundEntitiesVo = KylinOrderRefundEntitiesVo.getNew();
            BeanUtils.copyProperties(kylinOrderRefundEntities, orderRefundEntitiesVo);
            orderRefundEntitiesVo.setCreatedAt(strTime);
            mongoTemplate.insert(orderRefundEntitiesVo, KylinOrderRefundEntitiesVo.class.getSimpleName());

            //退款图片
            KylinOrderRefundPic orderRefundPic = new KylinOrderRefundPic();
            orderRefundPic.setRefundPicId(IDGenerator.nextSnowId());
            orderRefundPic.setOrderRefundsId(kylinOrderRefunds.getOrderRefundsId());
            orderRefundPic.setPicUrl(picList);
            orderRefundPic.setCreatedAt(time);

            KylinOrderRefundPicVo orderRefundPicVo = new KylinOrderRefundPicVo();
            BeanUtils.copyProperties(orderRefundPic, orderRefundPicVo);
            orderRefundPicVo.setCreatedAt(strTime);
            mongoTemplate.insert(orderRefundPicVo, KylinOrderRefundPicVo.class.getSimpleName());

            dataUtils.delOrderRefundVoByOrderId(orderInfo.getOrderTicketsId());
            //MQ
            LinkedList<String> sqls = CollectionUtil.linkedListString();
            LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> sqlsDataB = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> sqlsDataC = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> sqlsDataD = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> sqlsDataE = CollectionUtil.linkedListObjectArr();

            sqls.add(SqlMapping.get("kylin_order_ticket_status.refund"));
            sqls.add(SqlMapping.get("kylin_order_ticket_entities.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund_entities.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund_pic.refund"));

            sqlsDataA.add(new Object[]{
                    orderStatusTable.getStatus(), orderStatusTable.getUpdatedAt(), orderInfo.getOrderTicketsId(), orderInfo.getChangeDate(), orderInfo.getChangeDate()
            });
            sqlsDataB.add(new Object[]{
                    entitiesTable.getIsPayment(), entitiesTable.getUpdatedAt(), orderEntitiesId, orderInfo.getChangeDate(), orderInfo.getChangeDate()
            });
            sqlsDataC.add(new Object[]{
                    kylinOrderRefunds.getOrderRefundsId(), kylinOrderRefunds.getOrderTicketsId(), kylinOrderRefunds.getOrderRefundCode(),
                    kylinOrderRefunds.getPrice(), kylinOrderRefunds.getPriceExpress(), kylinOrderRefunds.getStatus(),
                    kylinOrderRefunds.getType(), kylinOrderRefunds.getApplicantId(), kylinOrderRefunds.getApplicantName(),
                    kylinOrderRefunds.getApplicantAt(), kylinOrderRefunds.getReason(),
                    kylinOrderRefunds.getRefundCate(), kylinOrderRefunds.getCreatedAt()
            });
            sqlsDataD.add(new Object[]{
                    kylinOrderRefundEntities.getOrderRefundsEntitiesId(), kylinOrderRefundEntities.getOrderRefundsId(), kylinOrderRefundEntities.getRefundPrice(),
                    kylinOrderRefundEntities.getOrderTicketEntitiesId(), kylinOrderRefundEntities.getCreatedAt()
            });
            sqlsDataE.add(new Object[]{
                    orderRefundPic.getOrderRefundsId(), orderRefundPic.getOrderRefundsId(), orderRefundPic.getPicUrl(), orderRefundPic.getCreatedAt()
            });

            queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_REFUND.getKey(),
                    SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD, sqlsDataE));

            return kylinOrderRefunds.getOrderRefundsId();
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}
