package com.liquidnet.commons.lang.util;

import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import java.security.SecureRandom;

/**
 * @author <a href="mailto:kowlone2006@163.com">zoumeng</a>
 * @version 1.0 2016/3/25 17:01
 */
public class PasswordEncoder {

    private BCryptPasswordEncoder instance() {
        SecureRandom random = new SecureRandom();
        return  new BCryptPasswordEncoder(10, random);
    }

    public static PasswordEncoder getInstance() {
        return new PasswordEncoder();
    }

    /**
     * 加密
     * @param plainPassWord 明文的密码
     * @return  加密后的密码
     */
    public String encode(String plainPassWord){
        return instance().encode(plainPassWord);
    }

    /**
     * 密码匹配
     * @param plainPassWord  明文
     * @param encodedPassword 存储的加密后的密码
     * @return 匹配成功返回True
     */
    public Boolean matches(String plainPassWord, String encodedPassword){
        return instance().matches(plainPassWord, encodedPassword);
    }


    public static void main(String[] args){
        PasswordEncoder pass = new PasswordEncoder();
        System.out.println(pass.encode("liuxiaohua"));
    }
}
