package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberPriceVo", description = "会员价格")
@Data
public class AdamMemberPriceVo implements Serializable {
    private static final long serialVersionUID = -8106910166417645208L;
    @ApiModelProperty(position = 1, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 2, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 3, value = "价格状态[0-不可用,1-上线中,2-已下线]")
    private Integer state;
    @ApiModelProperty(position = 4, value = "价格包名称")
    private String name;
    @ApiModelProperty(position = 5, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(position = 6, value = "折扣价")
    private BigDecimal priceFixed;
    @ApiModelProperty(position = 7, value = "有效天数")
    private Integer days;
    @ApiModelProperty(position = 8, value = "会员包须知")
    private String detail;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final AdamMemberPriceVo obj = new AdamMemberPriceVo();

    public static AdamMemberPriceVo getNew() {
        try {
            return (AdamMemberPriceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberPriceVo();
        }
    }

    public AdamMemberPriceVo copy(AdamMemberPrice source) {
        if (null == source) return this;
        this.setMemberPriceId(source.getMemberPriceId());
        this.setMemberId(source.getMemberId());
        this.setState(source.getState());
        this.setName(source.getName());
        this.setPrice(source.getPrice());
        this.setPriceFixed(source.getPriceFixed());
        this.setDays(source.getDays());
        this.setDetail(source.getDetail());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }
}
