package com.liquidnet.service.adam.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberPriceBuildParam", description = "编辑价格入参")
@Data
public class AdamMemberPriceBuildParam implements Serializable {
    private static final long serialVersionUID = -7331274160877946420L;
    @ApiModelProperty(required = true, value = "会员卡ID")
    private String memberId;
    @ApiModelProperty(required = false, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(required = true, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(required = true, value = "折扣价")
    private BigDecimal priceFixed;
    @ApiModelProperty(required = true, value = "特价:首次、首年优惠价")
    private BigDecimal priceSpecial;
    @ApiModelProperty(required = true, value = "有效天数")
    private Integer days;

    @ApiModelProperty(required = true, value = "双倍积分[1-关闭,2-开启]")
    private Integer integralRate;
}
