/*
 Navicat Premium Data Transfer

 Source Server         : mysql-5.7.27
 Source Server Type    : MySQL
 Source Server Version : 50727
 Source Host           : 127.0.0.1:3306
 Source Schema         : liquidnet_bank

 Target Server Type    : MySQL
 Target Server Version : 50727
 File Encoding         : 65001

 Date: 17/12/2020 16:42:37
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

drop schema if exists liquidnet_bank;
create database liquidnet_bank character set utf8mb4 collate utf8mb4_unicode_ci;

use `liquidnet_bank`;
-- ----------------------------
-- Table structure for bank_cc_account
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_account`;
CREATE TABLE `bank_cc_account` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `legal_entity_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Legal entity. company\nindividual',
  `account_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Account name.',
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `your_reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'First line of address.',
  `city` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'City.',
  `state_or_province` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Two-letter country code.',
  `postal_code` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `spread_table` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `identification_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'A legal document that verifies the identity of the account owner.',
  `identification_value` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'A unique reference code for the identification document, such as a passport number. Required if "identification_type" is provided.',
  `short_reference` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `api_trading` tinyint(1) DEFAULT NULL,
  `online_trading` tinyint(1) DEFAULT NULL,
  `phone_trading` tinyint(1) DEFAULT NULL,
  `process_third_party_funds` tinyint(1) DEFAULT NULL,
  `settlement_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL COMMENT 'create time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'update time',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for bank_cc_balance
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_balance`;
CREATE TABLE `bank_cc_balance` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `amount_from` decimal(20,2) DEFAULT NULL,
  `amount_to` decimal(20,2) DEFAULT NULL,
  `as_at_date` timestamp NULL DEFAULT NULL,
  `scope` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL COMMENT 'create time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'update time',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for bank_cc_beneficiary
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_beneficiary`;
CREATE TABLE `bank_cc_beneficiary` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Beneficiary name.',
  `bank_account_holder_name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Bank account holder''s name.',
  `bank_country` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '	Two-letter code for the country in which the beneficiary''s bank account is held.',
  `currency` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Currency in which money is held in the beneficiary''s bank account. Three-digit currency code.',
  `email` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_country` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `routing_code_type_1` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `routing_code_value_1` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Routing code for "routing_code_type_1".',
  `routing_code_type_2` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `routing_code_value_2` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bic_swift` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iban` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_beneficiary` tinyint(1) DEFAULT '0' COMMENT 'Payments are made automatically to default beneficiaries when a beneficiary is not specified.',
  `bank_address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_entity_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_company_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Required if "beneficiary_entity_type" is "company".',
  `beneficiary_first_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Required if "beneficiary_entity_type" is "individual".',
  `beneficiary_last_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Required if "beneficiary_entity_type" is "individual".',
  `beneficiary_city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_postcode` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_state_or_province` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_date_of_birth` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'If "beneficiary_entity_type" is "company", date of registration. If "beneficiary_entity_type" is "individual", date of birth. ISO 8601 format YYYY-MM-DD.',
  `beneficiary_identification_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'A legal document that verifies the identity of the beneficiary. Required documentation will vary depending on the country in which the beneficiary''s bank account is held.',
  `payment_types` json DEFAULT NULL,
  `on_behalf_of` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `beneficiary_external_reference` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc_account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bank_cc_beneficiaries_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='currency cloud beneficiaries table';

-- ----------------------------
-- Table structure for bank_cc_contact
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_contact`;
CREATE TABLE `bank_cc_contact` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_id` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `your_reference` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_phone_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locale` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_of_birth` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL COMMENT 'create time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'update time',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for bank_cc_payer
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_payer`;
CREATE TABLE `bank_cc_payer` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `legal_entity_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_or_province` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_of_birth` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identification_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identification_value` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `on_behalf_of` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remote_payer_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc_account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bank_cc_payer_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for bank_cc_payment
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_payment`;
CREATE TABLE `bank_cc_payment` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beneficiary_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `creator_contact_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_date` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transferred_at` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorisation_steps_required` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_updater_contact_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_reference` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `conversion_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failure_reason` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payer_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payer_details_source` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payment_group_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unique_request_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failure_returned_amount` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ultimate_beneficiary_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purpose_code` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `charge_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fee_amount` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fee_currency` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bank_cc_payment_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='下发表';

-- ----------------------------
-- Table structure for bank_cc_push_log
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_push_log`;
CREATE TABLE `bank_cc_push_log` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notification_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` json DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for bank_cc_transaction
-- ----------------------------
DROP TABLE IF EXISTS `bank_cc_transaction`;
CREATE TABLE `bank_cc_transaction` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(20,2) DEFAULT NULL,
  `balance_amount` decimal(20,2) DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_entity_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_entity_id` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_entity_short_reference` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settles_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS = 1;
