package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryRespDto;
import com.liquidnet.service.galaxy.router.strategy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinPublishBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:05
 */
@Slf4j
@Component
public class ZxinPublishBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private ZxinCommonBiz zxinCommonBiz;

    /**
     * nft发行
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(GalaxyNftPublishReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNotNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getMessage());
        }

        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());

        String author = seriesNftInfoBo.getAuthor();
        String nftName = seriesNftInfoBo.getNftName();
        String nftUrl = seriesNftInfoBo.getNftUrl();
        String displayUrl = seriesNftInfoBo.getDisplayUrl();

        String nftDesc = seriesNftInfoBo.getNftDesc();
        String nftFlag = seriesNftInfoBo.getNftFlag();
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 0;
        Long sellCount = seriesNftInfoBo.getSellCount().longValue(); //积分
        /**
         * 根据sku获取系列Id
         */
        String seriesId = seriesNftInfoBo.getSeriesId();
        //返回参数nftId
        String nftId = null;
        String taskId = null;


        //查询系列信息
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        if(resp.isSuccess()){
            //该系列已经发行多少个nft
            Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
            log.info("系列：{} 已发行 ：{}", seriesId, crtCount);
            //设置开始索引
            seriesBeginIndex = Integer.parseInt(String.valueOf(crtCount.longValue() + 1));
        }

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(nftName);
        nft034ReqDto.setUrl(nftUrl);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(nftDesc);
        nft034ReqDto.setFlag(nftFlag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if (nft034RespDto.isSuccess()) {
            taskId = nft034RespDto.getData().getTaskId();
        }

        GalaxyNftPublishRespDto nftPublishRespDto = GalaxyNftPublishRespDto.getNew();
        nftPublishRespDto.setUserId(reqDto.getUserId());
        nftPublishRespDto.setNftId(nftId);

        //构造缓存数据
        if(nftOrderBo==null){
            nftOrderBo = zxinCommonBiz.buildNftOrderBo(reqDto.getNftOrderPayId(),userInfoBo,seriesNftInfoBo);
            nftOrderBo.setNftId(nftId);
            nftOrderBo.setNftPublishTaskId(taskId);
            dataUtils.setNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);
        }
        return ResponseDto.success(nftPublishRespDto);
    }

    /**
     * nft发行结果查询
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishResultQueryRespDto> nftPublishResultQuery(GalaxyNftPublishResultQueryReqDto reqDto){
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        //3.1.4查询 NFT发行结果
        Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
        nft035ReqDto.setTaskId(nftOrderBo.getNftPublishTaskId());

        ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
        if(nft035RespDtoTemp.isSuccess()){
            //设置时间
            String nftPublishChainTimestampStr = DateUtil.format(new Date(nft035RespDtoTemp.getData().getChainTimestamp().longValue()*1000),DateUtil.Formatter.yyyyMMddHHmmss);
            //转换任务状态
            String nftPublishStatusStr = GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),nft035RespDtoTemp.getData().getTaskStatus().toString()).getCode();

            //更新缓存数据状态
            nftOrderBo.setNftId(nft035RespDtoTemp.getData().getNftIdBegin());
            nftOrderBo.setNftPublishChainTimestamp(nftPublishChainTimestampStr);
            nftOrderBo.setNftPublishStatus(nftPublishStatusStr);
            nftOrderBo.setNftPublishTradeHash(nft035RespDtoTemp.getData().getTxHash());
            nftOrderBo.setUpdatedAt(LocalDateTime.now());
            dataUtils.updateNftOrderPublishInfo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);

            //构造返回结果
            GalaxyNftPublishResultQueryRespDto nftPublishResultQueryRespDto = GalaxyNftPublishResultQueryRespDto.getNew();
            BeanUtil.copy(nft035RespDtoTemp.getData(),nftPublishResultQueryRespDto);
            nftPublishResultQueryRespDto.setChainTimestamp(nftPublishChainTimestampStr);
            nftPublishResultQueryRespDto.setTaskStatus(Integer.valueOf(nftPublishStatusStr));

            return ResponseDto.success(nftPublishResultQueryRespDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL.getCode(), GalaxyErrorEnum.PUBLISH_FAIL.getMessage());
        }
    }

    /**
     * 以下为nft发行同步返回方法(暂时废弃)
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishRespDto> nftPublishSync(GalaxyNftPublishReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNotNull(nftOrderBo)&&StringUtil.isNotEmpty(nftOrderBo.getNftId())){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getMessage());
        }

        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());

        String author = seriesNftInfoBo.getAuthor();
        String nftName = seriesNftInfoBo.getNftName();
        String nftUrl = seriesNftInfoBo.getNftUrl();
        String displayUrl = seriesNftInfoBo.getDisplayUrl();

        String nftDesc = seriesNftInfoBo.getNftDesc();
        String nftFlag = seriesNftInfoBo.getNftFlag();
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 0;
        Long sellCount = Long.valueOf(seriesNftInfoBo.getSellCount().multiply(BigDecimal.valueOf(100l)).longValue()); //积分
        /**
         * 根据sku获取系列Id
         */
        String seriesId = seriesNftInfoBo.getSeriesId();
        //返回参数nftId
        String nftId = null;
        String taskId = null;
        Long nftPublishChainTimestamp = null;
        Integer nftPublishStatus = null;
        String nftPublishTradeHash = null;


        //查询系列信息
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        if(resp.isSuccess()){
            //该系列已经发行多少个nft
            Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
            log.info("系列：{} 已发行 ：{}", seriesId, crtCount);
            //设置开始索引
            seriesBeginIndex = Integer.parseInt(String.valueOf(crtCount.longValue() + 1));
        }

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(nftName);
        nft034ReqDto.setUrl(nftUrl);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(nftDesc);
        nft034ReqDto.setFlag(nftFlag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if (nft034RespDto.isSuccess()) {
            //3.1.4查询 NFT发行结果
            Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
            taskId = nft034RespDto.getData().getTaskId();
            nft035ReqDto.setTaskId(taskId);

            int count = 0;
            String nftIdBegin = null;
            long timeStart = System.currentTimeMillis();
            while (StringUtil.isEmpty(nftIdBegin)) {
                //休眠1秒钟，等待执行结果
                try {
                    Thread.sleep(1000l);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                count++;
                ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
                log.info("=======执行第{}次查询,taskId:{}", count, nft035ReqDto.getTaskId());
                if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                    nftIdBegin = nft035RespDtoTemp.getData().getNftIdBegin();
                    nftPublishChainTimestamp = nft035RespDtoTemp.getData().getChainTimestamp();
                    nftPublishStatus = nft035RespDtoTemp.getData().getTaskStatus();
                    nftPublishTradeHash = nft035RespDtoTemp.getData().getTxHash();
                } else if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                    log.info("任务执行失败！taskId:{}", nft035ReqDto.getTaskId());
                    return null;
                }

                if (count == 5) {
                    log.info("=======查询共5次，跳出循环！taskId:{}", nft035ReqDto.getTaskId());
                    break;
                }
            }

            //赋值返回参数
            nftId = nftIdBegin;
            log.info("发行NFT后返回给前端nftID:{}", nftIdBegin);
            log.info("总共执行了{}次查询 总耗时:{} MS", count, (System.currentTimeMillis() - timeStart));
        }


        if(StringUtil.isEmpty(nftId)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL.getCode(), GalaxyErrorEnum.PUBLISH_FAIL.getMessage());
        }

        GalaxyNftPublishRespDto nftPublishRespDto = GalaxyNftPublishRespDto.getNew();
        nftPublishRespDto.setUserId(reqDto.getUserId());
        nftPublishRespDto.setNftId(nftId);

        //构造缓存数据
        if(nftOrderBo==null){
            nftOrderBo = zxinCommonBiz.buildNftOrderBo(reqDto.getNftOrderPayId(),userInfoBo,seriesNftInfoBo);
            nftOrderBo.setNftId(nftId);
            nftOrderBo.setNftPublishTaskId(taskId);
            //设置时间
            String nftPublishChainTimestampStr = DateUtil.format(new Date(nftPublishChainTimestamp*1000),DateUtil.Formatter.yyyyMMddHHmmss);
            //转换任务状态
            String nftPublishStatusStr = GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),nftPublishStatus.toString()).getCode();
            nftOrderBo.setNftPublishChainTimestamp(nftPublishChainTimestampStr);
            nftOrderBo.setNftPublishStatus(nftPublishStatusStr);
            nftOrderBo.setNftPublishTradeHash(nftPublishTradeHash);
            nftOrderBo.setUpdatedAt(LocalDateTime.now());
            dataUtils.setNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId(),nftOrderBo);
        }
        return ResponseDto.success(nftPublishRespDto);
    }
}
