package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.ArrayList;

@Slf4j
@Api(tags = "正在下单相关-商铺")
@RestController
@RequestMapping("/store/coupon")
public class GoblinCouponController {

    @Autowired
    GoblinCouponService goblinCouponService;

    @PostMapping("type")
    @ApiOperation("商品可参与券类型")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺id"),
    })
    public ResponseDto<ArrayList<String>> getSpuType(@RequestParam("spuId") @Valid String spuId,
                                                     @RequestParam("storeId") @Valid String storeId) {
        return ResponseDto.success(goblinCouponService.getSpuType(spuId, storeId));
    }

    @PostMapping("type/list")
    @ApiOperation("券列表[根据类型]")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "券类型[1-代金券|2-折扣券|3-满减券]"),
    })
    public ResponseDto<ArrayList<GoblinStoreCouponVo>> checkOrderResult(@RequestParam("spuId") @Valid String spuId,
                                                                        @RequestParam("storeId") @Valid String storeId,
                                                                        @RequestParam("type") @Valid String type) {
        return ResponseDto.success(goblinCouponService.getSpuByType(spuId, storeId, type));
    }

    @PostMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeCouponId", value = "平台券id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "number", value = "数量"),
    })
    public ResponseDto<Boolean> checkOrderResult(@RequestParam("storeCouponId") @Valid String storeCouponId,
                                                 @RequestParam("number") @Valid Integer number) {
        return ResponseDto.success(goblinCouponService.receiveCoupon(storeCouponId, number));
    }
}
