package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "GoblinStoreMgtInfoVo", description = "店铺信息详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtInfoVo implements java.io.Serializable, Cloneable  {
    private static final long serialVersionUID = 6109909470490181810L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 11, value = "店铺名称[128]")
    private String storeName;
    @ApiModelProperty(position = 12, value = "店铺LOGO[256]")
    private String logoPic;
    @ApiModelProperty(position = 13, value = "店铺背景图[256]")
    private String backgroundPic;
    @ApiModelProperty(position = 14, value = "店铺介绍[500]")
    private String introduce;

    private static final GoblinStoreMgtInfoVo obj = new GoblinStoreMgtInfoVo();
    public static GoblinStoreMgtInfoVo getNew() {
        try {
            return (GoblinStoreMgtInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtInfoVo();
        }
    }
}
