package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 店铺公告
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreNotice implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 公告id
     */
    private String noticeId;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 公告内容
     */
    private String content;

    /**
     * 发布时间
     */
    @TableField("releaseTime")
    private LocalDateTime releaseTime;

    /**
     * 长期有效[0-否|1-是]
     */
    private LocalDateTime longLasting;

    /**
     * 结束时间
     */
    @TableField("cancellTime")
    private LocalDateTime cancellTime;

    /**
     * 公告状态[0-待发布|1-已发布]
     */
    private String status;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String comment;


}
