package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinAppOrderListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 店铺id")
    private String storeId;
    @ApiModelProperty(value = " 店铺id")
    private String storeName;
    @ApiModelProperty(value = " 订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)]")
    private Integer status;
    @ApiModelProperty(value = "过期倒计时", example = "")
    private Long restTime;
    @ApiModelProperty(value = "活动id")
    private String marketId;
    @ApiModelProperty(value = "活动类型[ZZ-正在下单]")
    private String marketType;
    @ApiModelProperty(value = "正在状态[0-未出货|1-已出货]")
    private Integer zhengzaiStatus;
    @ApiModelProperty(value = " sku")
    List<GoblinOrderSkuVo> orderSkuVos;
    private static final GoblinAppOrderListVo obj = new GoblinAppOrderListVo();
    public static GoblinAppOrderListVo getNew() {
        try {
            return (GoblinAppOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinAppOrderListVo();
        }
    }
}
