package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.*;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.param.GoblinFrontBannerBuildParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 轮播图 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */

@Api(tags = "banner管理")
@RestController
@RequestMapping("/frontBanner")
public class GoblinFrontBannerController extends BaseController {
    @Autowired
    GoblinFrontBannerServiceImpl goblinFrontBannerService;
    @Autowired
    GoblinFrontHotWordServiceImpl goblinFrontHotWordService;
    @Autowired
    GoblinFrontNavigationServiceImpl goblinFrontNavigationService;
    @Autowired
    GoblinFrontSeckillServiceImpl goblinFrontSeckillService;
    @Autowired
    GoblinFrontSelectGoodsServiceImpl goblinFrontSelectGoodsService;
    @Autowired
    GoblinFrontMoudleIndexServiceImpl goblinFrontMoudleIndexService;
    @Autowired
    GoblinFrontCompilationsServiceImpl goblinFrontCompilationsService;
    @Autowired
    GoblinFrontCubeServiceImpl goblinFrontCubeService;

    /**
     * @author zhangfuxin
     * @Description:添加banner
     * @date 2021/12/27 下午1:22
     */
    /*@PostMapping("create")
    @ApiOperation(value = "增加banner")
    @ResponseBody
    public AjaxResult create(@RequestBody GoblinFrontBannerBuildParam goblinFrontBannerBuildParam) {
        GoblinFrontBanner goblinFrontBanner=new GoblinFrontBanner();
        BeanUtils.copyProperties(goblinFrontBannerBuildParam,goblinFrontBanner);
        logger.info("增加banner{}", JSON.toJSONString(goblinFrontBanner));
        boolean result=goblinFrontBannerService.create(goblinFrontBanner);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
*/
    @PostMapping("updateOrCreate")
    @ApiOperation(value = "修改或者增加banner")
    @ResponseBody
    public AjaxResult updateOrCreate(@RequestBody List<GoblinFrontBannerBuildParam> list) {
        List<GoblinFrontBanner> goblinFrontBannerList=new ArrayList<>();
        for(GoblinFrontBannerBuildParam goblinFrontBannerBuildParam1:list){
            GoblinFrontBanner goblinFrontBanner=new GoblinFrontBanner();
            BeanUtils.copyProperties(goblinFrontBannerBuildParam1,goblinFrontBanner);
            goblinFrontBannerList.add(goblinFrontBanner);
        }
        logger.info("修改banner{}", JSON.toJSONString(list));
        boolean result=goblinFrontBannerService.update(goblinFrontBannerList);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("delete")
    @ApiOperation(value = "删除banner")
    @ResponseBody
    public AjaxResult delete( @RequestBody GoblinFrontBannerBuildParam goblinFrontBannerBuildParam) {
        GoblinFrontBanner goblinFrontBanner=new GoblinFrontBanner();
        BeanUtils.copyProperties(goblinFrontBannerBuildParam,goblinFrontBanner);
        logger.info("删除banner{}", JSON.toJSONString(goblinFrontBanner));
        boolean result=goblinFrontBannerService.delte(goblinFrontBanner.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    /*@PostMapping("getOne")
    @ApiOperation(value = "查看详情")
    @ResponseBody
    public AjaxResult getOne( @RequestBody GoblinFrontBannerBuildParam goblinFrontBannerBuildParam) {
        GoblinFrontBanner goblinFrontBanner=new GoblinFrontBanner();
        BeanUtils.copyProperties(goblinFrontBannerBuildParam,goblinFrontBanner);
        logger.info("查看详情{}", JSON.toJSONString(goblinFrontBanner));
        GoblinFrontBanner goblinFrontBanner1=goblinFrontBannerService.getOne(goblinFrontBanner.getMid());
        return AjaxResult.success(goblinFrontBanner1);
    }
    @PostMapping("page")
    @ApiOperation(value = "分页")
    @ResponseBody
    public AjaxResult page( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNumber", required = true)int pageNumber,@RequestBody  GoblinFrontBannerBuildParam goblinFrontBannerBuildParam) {
        GoblinFrontBanner goblinFrontBanner=new GoblinFrontBanner();
        BeanUtils.copyProperties(goblinFrontBannerBuildParam,goblinFrontBanner);
        logger.info("分页banner{}", JSON.toJSONString(goblinFrontBanner));
        return AjaxResult.success(goblinFrontBannerService.bannerPage(pageSize,pageNumber,null));
    }*/
    @PostMapping("list")
    @ApiOperation(value = "list")
    @ResponseBody
    public AjaxResult list( @RequestParam(name = "type", required = true) String  type) {
        return AjaxResult.success(goblinFrontBannerService.listGoblinFrontBanner(type));
    }

    @PostMapping("online")
    @ApiOperation(value = "上线")
    @ResponseBody
    public AjaxResult online( ) {
        logger.info("上线操作");
        boolean bannerResult=goblinFrontBannerService.online();
        logger.info("bannerResult,{}",bannerResult);
        boolean bannerMiddle=goblinFrontBannerService.middle();
        logger.info("banner中部{}",bannerMiddle);
        boolean hotWordResult=goblinFrontHotWordService.online();
        logger.info("热词,{}",hotWordResult);
        boolean navigationResult=goblinFrontNavigationService.online();
        logger.info("导航栏,{}",navigationResult);
        /*  boolean secillResult=goblinFrontSeckillService.online();
        logger.info("限时秒杀,{}",secillResult);*/
        boolean selectGoods=goblinFrontSelectGoodsService.online();
        logger.info("精选商品{}",selectGoods);
        boolean moudleIndexResult=goblinFrontMoudleIndexService.online();
        logger.info("组件排序{}",moudleIndexResult);
        //魔方
        boolean cubeResult=goblinFrontCubeService.online();
        logger.info("魔方{}",cubeResult);
        boolean recommendResult=goblinFrontCubeService.onlineRecommend();
        logger.debug("新品推荐{}",recommendResult);
/*        boolean hejiReult=goblinFrontCompilationsService.online();
        logger.info("合集{}",hejiReult);*/
        if (bannerResult&&hotWordResult&&navigationResult&bannerMiddle&&selectGoods&&moudleIndexResult&&cubeResult ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }


}
