package com.liquidnet.service.feign.kylin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-platform",
        contextId = "FeignPlatformTaskClient", path = "",
        url = "${liquidnet.service.platform.url}",
//        url = "",
        fallback = FallbackFactory.Default.class)
public interface FeignPlatformTaskClient {

    @PostMapping("platform/order/checkOrderTime")
    ResponseDto<Boolean> checkOrderTime();

    @PostMapping("platform/performance/checkPerformanceTime")
    ResponseDto<String> checkPerformanceTime();

    @PostMapping("platform/order/checkTransferOrder")
    ResponseDto<Boolean> checkTransferOrder(@RequestParam("minute") Integer minute);

    @PostMapping("platform/order/goblin/checkOrderTime")
    ResponseDto<Boolean> checkGoblinOrderTime();

    @GetMapping("platform/performance/line")
    ResponseDto<Boolean> performanceLine();
    
    /**
     * 定时开票提醒
     * @author zjp
     * @return: com.liquidnet.service.base.ResponseDto<java.lang.Boolean>
     * @date 2024/3/21 18:03
    */
    @GetMapping("platform/performance/subscribePush")
    ResponseDto<Boolean> performanceSubscribePush();
    
    /*
     * @description: 自动处理退款失败
     * @author: zjp
     * @date: 2025/4/27 14:28
     * @param: []
     * @return: com.liquidnet.service.base.ResponseDto<java.lang.Boolean>
     **/
    @GetMapping("platform/refund/failRefund")
    ResponseDto<Boolean> failRefund();
}
