package com.liquidnet.service.adam.constant;

import com.liquidnet.common.exception.constant.ErrorCode;

public class AdamUserConst {

    public enum UserAuthTypeEnum {
        EMAIL,
        SMS_CODE
    }

    public enum UserAuthResultEnum {
        SUCCESS,
        FAILURE,
        PENDING
    }

    public enum UserRoleEnum {
        Administrator, Executor, Viewer;
    }

    public enum Logical {
        AND, OR;
    }

    public enum UserStatusEnum{
            REMOVED("0","Removed"),
            ACTIVE("1","Active"),
            INVITED("2","Invited");
        private String code;

        private String desc;

        UserStatusEnum(String code,String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static UserStatusEnum byCode(String code) {
            UserStatusEnum[] values = UserStatusEnum.values();
            for (UserStatusEnum v : values) {
                if (v.code.equals(code)) {
                    return v;
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum UserLoginLogMsgTypeEnum{

        LOGIN_SUCCESS(ErrorCode.SUCCESS.getCode(), "login success"),
        LOGIN_FAIL(ErrorCode.ERROR.getCode(), "login fail"),
        LOGIN_OUT_SUCCESS(ErrorCode.SUCCESS.getCode(), "login out success"),
        LOGIN_OUT_FORCE_MSG_OTHER_SITE(ErrorCode.SUCCESS.getCode(), "force login out(other site)"),
        LOGIN_OUT_FORCE_MSG_USER_FROZEN(ErrorCode.SUCCESS.getCode(), "force login out(user frozen)"),
        LOGIN_OUT_FORCE_MSG_COM_FROZEN(ErrorCode.SUCCESS.getCode(), "force login out(company frozen)"),
        LOGIN_OUT_FORCE_MSG_SYS_UPDATE(ErrorCode.SUCCESS.getCode(), "force login out(system update)"),
        LOGIN_OUT_FORCE_MSG_LOGIN_TIMEOUT(ErrorCode.SUCCESS.getCode(), "force login out(login timeout)"),
        LOGIN_OUT_FORCE_MSG_EMAIL_UPDATE(ErrorCode.SUCCESS.getCode(), "force login out(email update)"),
        REGISTER_SUCCESS(ErrorCode.SUCCESS.getCode(), "Balances"),
        REGISTER_FAIL(ErrorCode.ERROR.getCode(), "Transactions")
        ;

        private String status;

        private String desc;

        UserLoginLogMsgTypeEnum(String status,String desc) {
            this.status = status;
            this.desc = desc;
        }

        public String getStatus() {
            return status;
        }

        public String getDesc() {
            return desc;
        }


        public static UserLoginLogMsgTypeEnum getEnumByName(String name){
            UserLoginLogMsgTypeEnum[] enums = UserLoginLogMsgTypeEnum.values();
            UserLoginLogMsgTypeEnum rsEnum = null;
            for(UserLoginLogMsgTypeEnum r:enums){
                if(r.name().equalsIgnoreCase(name)){
                    rsEnum = r;
                }
            }
            return rsEnum;
        }

        public static String getDescByName(String name){
            UserLoginLogMsgTypeEnum[] enums = UserLoginLogMsgTypeEnum.values();
            String desc = "";
            for(UserLoginLogMsgTypeEnum r:enums){
                if(r.name().equalsIgnoreCase(name)){
                    desc = r.getDesc();
                }
            }
            return desc;
        }
    }
}
