package com.liquidnet.service.consumer.service.processor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.stereotype.Component;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange("queue_test"),
            key = "queue_key",
            value = @Queue("queue_adam")
    ))
    @RabbitHandler
    public void consumerSql(Message message) {
        log.info("consumer sql:{}", message);
    }
}
