package com.liquidnet.service.account.wallet.dto.base;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModelProperty;

public class WalletCallParam implements java.io.Serializable {
    private static final long serialVersionUID = -5043666161217655387L;
    @ApiModelProperty(position = 1, required = true, value = "Wallet channel ID [32]", example = "50001")
    private String channelId;
    @ApiModelProperty(position = 2, required = true, value = "Wallet channel biz type [16]", example = "000")
    private String bizType;

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String txData() {
        String sn = this.getClass().getSimpleName();
        return String.format("%-" + (50 - sn.length()) + "s" + sn, "") + JsonUtils.toJson(this);
    }
}
